/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002J\"\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isThis", "", "element", "(ZLorg/jetbrains/kotlin/psi/KtSecondaryConstructor;)V", "()Z", "keywordToUse", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "InsertSuperDelegationCallFactory", "InsertThisDelegationCallFactory", "kotlin.idea"})
public final class InsertDelegationCallQuickfix
extends KotlinQuickFixAction<KtSecondaryConstructor> {
    private final boolean isThis;
    @NotNull
    private final String keywordToUse;

    public InsertDelegationCallQuickfix(boolean isThis, @NotNull KtSecondaryConstructor element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.isThis = isThis;
        this.keywordToUse = this.isThis ? "this" : "super";
    }

    public final boolean isThis() {
        return this.isThis;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.keywordToUse};
        return KotlinBundle.message("fix.insert.delegation.call", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("insert.explicit.delegation.call", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)this.getElement();
            if (ktSecondaryConstructor == null) {
                return;
            }
            KtSecondaryConstructor element3 = ktSecondaryConstructor;
            KtConstructorDelegationCall newDelegationCall = element3.replaceImplicitDelegationCallWithExplicit(this.isThis);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)newDelegationCall, BodyResolveMode.FULL);
            DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)element3, null, 1, null);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            boolean bl = resolvedCall3 != null ? ArgumentMappingKt.isReallySuccess(resolvedCall3) : false;
            if (bl && !Intrinsics.areEqual((Object)resolvedCall2.getCandidateDescriptor().getOriginal(), (Object)descriptor2)) {
                return;
            }
            KtValueArgumentList ktValueArgumentList = newDelegationCall.getValueArgumentList();
            Intrinsics.checkNotNull((Object)ktValueArgumentList);
            PsiElement psiElement2 = ktValueArgumentList.getLeftParenthesis();
            Intrinsics.checkNotNull((Object)psiElement2);
            int leftParOffset = psiElement2.getTextOffset();
            Editor editor3 = editor2;
            if (editor3 == null) break block2;
            GenerateUtilsKt.moveCaret$default(editor3, leftParOffset + 1, null, 2, null);
        }
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)this.getElement();
        if (ktSecondaryConstructor == null) {
            return false;
        }
        KtSecondaryConstructor element3 = ktSecondaryConstructor;
        return element3.hasImplicitDelegationCall();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertSuperDelegationCallFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nInsertDelegationCallQuickfix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertDelegationCallQuickfix.kt\norg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertSuperDelegationCallFactory\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,77:1\n146#2:78\n*S KotlinDebug\n*F\n+ 1 InsertDelegationCallQuickfix.kt\norg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertSuperDelegationCallFactory\n*L\n68#1:78\n*E\n"})
    public static final class InsertSuperDelegationCallFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final InsertSuperDelegationCallFactory INSTANCE = new InsertSuperDelegationCallFactory();

        private InsertSuperDelegationCallFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$getNonStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtSecondaryConstructor.class, (boolean)false);
            if (ktSecondaryConstructor == null) {
                return null;
            }
            KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
            if (!secondaryConstructor.hasImplicitDelegationCall()) {
                return null;
            }
            KtClassOrObject ktClassOrObject = secondaryConstructor.getContainingClassOrObject();
            KtClass ktClass2 = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
            if (ktClass2 == null) {
                return null;
            }
            KtClass klass2 = ktClass2;
            if (klass2.hasPrimaryConstructor()) {
                return null;
            }
            return new InsertDelegationCallQuickfix(false, secondaryConstructor);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertThisDelegationCallFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getConstructorsCount", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nInsertDelegationCallQuickfix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertDelegationCallQuickfix.kt\norg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertThisDelegationCallFactory\n+ 2 quickfixUtil.kt\norg/jetbrains/kotlin/idea/util/QuickfixUtilKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,77:1\n25#2:78\n146#3:79\n*S KotlinDebug\n*F\n+ 1 InsertDelegationCallQuickfix.kt\norg/jetbrains/kotlin/idea/quickfix/InsertDelegationCallQuickfix$InsertThisDelegationCallFactory\n*L\n55#1:78\n55#1:79\n*E\n"})
    public static final class InsertThisDelegationCallFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final InsertThisDelegationCallFactory INSTANCE = new InsertThisDelegationCallFactory();

        private InsertThisDelegationCallFactory() {
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtSecondaryConstructor> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Diagnostic $this$createIntentionForFirstParentOfType$iv = diagnostic;
            boolean $i$f$createIntentionForFirstParentOfType = false;
            PsiElement $this$getNonStrictParentOfType$iv$iv = $this$createIntentionForFirstParentOfType$iv.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtSecondaryConstructor.class, (boolean)false);
            if (psiElement2 != null) {
                KtSecondaryConstructor secondaryConstructor = (KtSecondaryConstructor)psiElement2;
                boolean bl = false;
                return INSTANCE.getConstructorsCount(secondaryConstructor.getContainingClassOrObject()) <= 1 || !secondaryConstructor.hasImplicitDelegationCall() ? null : new InsertDelegationCallQuickfix(true, secondaryConstructor);
            }
            return null;
        }

        private final int getConstructorsCount(KtClassOrObject $this$getConstructorsCount) {
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)$this$getConstructorsCount);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            return ((ClassDescriptor)declarationDescriptor).getConstructors().size();
        }
    }
}

