/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.names.FqNames;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.CanSealedSubClassBeObjectInspection;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.AddFileAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.MakeModuleOptInFix;
import org.jetbrains.kotlin.idea.quickfix.OptInFixesFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0014\u0010\u0012\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findFileAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "annotationExists", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "fqName", "isSubclassOptPropagateApplicable", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "HighPriorityPropagateOptInAnnotationFix", "HighPriorityUseOptInAnnotationFix", "LowPriorityMakeModuleOptInFix", "PropagateOptInAnnotationFix", "UseOptInAnnotationFix", "UseOptInFileAnnotationFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nOptInFixesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInFixesFactory.kt\norg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,297:1\n1#2:298\n1747#3,2:299\n1749#3:302\n288#3,2:303\n1747#3,3:305\n110#4:301\n*S KotlinDebug\n*F\n+ 1 OptInFixesFactory.kt\norg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory\n*L\n140#1:299,2\n140#1:302\n153#1:303,2\n82#1:305,3\n144#1:301\n*E\n"})
public final class OptInFixesFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final OptInFixesFactory INSTANCE = new OptInFixesFactory();

    private OptInFixesFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement element3 = diagnostic.getPsiElement();
        Class[] classArray = new Class[]{KtDeclarationWithBody.class, KtClassOrObject.class, KtProperty.class, KtTypeAlias.class};
        KtDeclaration ktDeclaration = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)element3, (boolean)true, (Class[])classArray, (Function1)doCreateActions.containingDeclaration.1.INSTANCE);
        if (ktDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        KtDeclaration containingDeclaration2 = ktDeclaration;
        DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
        Object object = Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_USAGE) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_USAGE.cast((UnboundDiagnostic)diagnostic)).getA() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_USAGE_ERROR) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_USAGE_ERROR.cast((UnboundDiagnostic)diagnostic)).getA() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_OVERRIDE) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_OVERRIDE.cast((UnboundDiagnostic)diagnostic)).getA() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.OPT_IN_OVERRIDE_ERROR) ? (FqName)((DiagnosticWithParameters2)Errors.OPT_IN_OVERRIDE_ERROR.cast((UnboundDiagnostic)diagnostic)).getA() : null)));
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        FqName annotationFqName = object;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(containingDeclaration2, null, 1, null);
        if (declarationDescriptor == null || (declarationDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)declarationDescriptor)) == null) {
            return CollectionsKt.emptyList();
        }
        DeclarationDescriptor moduleDescriptor = declarationDescriptor;
        ClassDescriptor classDescriptor = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)moduleDescriptor, (FqName)annotationFqName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor;
        Set applicableTargets = AnnotationChecker.Companion.applicableTargetSet(annotationClassDescriptor);
        BindingContext context2 = element3 instanceof KtElement ? ResolutionUtils.analyze$default((KtElement)element3, null, 1, null) : ResolutionUtils.analyze$default((KtElement)containingDeclaration2, null, 1, null);
        boolean isOverrideError = Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_OVERRIDE_ERROR) || Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_OVERRIDE);
        FqName it = fqName2 = OptInNames.INSTANCE.getOPT_IN_FQ_NAME();
        boolean bl = false;
        Object object2 = INSTANCE.annotationExists((ModuleDescriptor)moduleDescriptor, it) ? fqName2 : null;
        if (object2 == null) {
            object2 = FqNames.OptInFqNames.INSTANCE.getOLD_USE_EXPERIMENTAL_FQ_NAME();
        }
        FqName optInFqName = object2;
        List result2 = new ArrayList();
        AddAnnotationFix.Kind kind2 = containingDeclaration2 instanceof KtConstructor ? (AddAnnotationFix.Kind)AddAnnotationFix.Kind.Constructor.INSTANCE : (AddAnnotationFix.Kind)new AddAnnotationFix.Kind.Declaration(containingDeclaration2.getName());
        OptInFixesFactory.doCreateActions$collectQuickFixes(context2, result2, isOverrideError, annotationFqName, optInFqName, applicableTargets, containingDeclaration2, kind2);
        KtClassOrObject containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)containingDeclaration2);
        if (containingDeclaration2 instanceof KtCallableDeclaration && containingClassOrObject != null) {
            OptInFixesFactory.doCreateActions$collectQuickFixes(context2, result2, isOverrideError, annotationFqName, optInFqName, applicableTargets, (KtDeclaration)containingClassOrObject, new AddAnnotationFix.Kind.ContainingClass(containingClassOrObject.getName()));
        }
        KtFile ktFile = containingDeclaration2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"containingDeclaration.containingKtFile");
        KtFile containingFile = ktFile;
        Module module2 = GenericPsiUtils.getModule((PsiElement)containingFile);
        if (module2 != null) {
            result2.add(new LowPriorityMakeModuleOptInFix(containingFile, module2, annotationFqName));
        }
        KtAnnotationEntry ktAnnotationEntry = this.findFileAnnotation(containingFile, optInFqName);
        result2.add(new UseOptInFileAnnotationFix(containingFile, optInFqName, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)(ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null)));
        return result2;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isSubclassOptPropagateApplicable(KtDeclaration $this$isSubclassOptPropagateApplicable, FqName annotationFqName) {
        block8: {
            block9: {
                if (!($this$isSubclassOptPropagateApplicable instanceof KtClass)) {
                    return false;
                }
                if (!(((KtClass)$this$isSubclassOptPropagateApplicable).isLocal() == false)) {
                    $i$a$-check-OptInFixesFactory$isSubclassOptPropagateApplicable$1 = false;
                    $i$a$-check-OptInFixesFactory$isSubclassOptPropagateApplicable$1 = "Local declarations are filtered in OptInFixesFactory.doCreateActions";
                    throw new IllegalStateException($i$a$-check-OptInFixesFactory$isSubclassOptPropagateApplicable$1.toString());
                }
                if (((KtClass)$this$isSubclassOptPropagateApplicable).isSealed() || $this$isSubclassOptPropagateApplicable.hasModifier(KtTokens.FUN_KEYWORD) || !KotlinRefactoringUtilKt.isOpen((KtClass)$this$isSubclassOptPropagateApplicable)) {
                    return false;
                }
                v0 = SearchHelpersKt.getDescriptor($this$isSubclassOptPropagateApplicable);
                if ((v0 != null && (v0 = v0.getAnnotations()) != null ? v0.findAnnotation(OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME()) : null) != null) {
                    return false;
                }
                $this$any$iv = ((KtClass)$this$isSubclassOptPropagateApplicable).getSuperTypeListEntries();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block9;
                v1 = false;
                break block8;
            }
            for (T element$iv : $this$any$iv) {
                block11: {
                    block12: {
                        block10: {
                            it = (KtSuperTypeListEntry)element$iv;
                            $i$a$-any-OptInFixesFactory$isSubclassOptPropagateApplicable$2 = false;
                            v2 = CanSealedSubClassBeObjectInspection.Companion.asKtClass(it);
                            if (v2 != null && (v2 = SearchHelpersKt.getDescriptor((KtDeclaration)v2)) != null) break block10;
                            v3 = false;
                            break block11;
                        }
                        superClassDescriptor = v2;
                        if (superClassDescriptor.getAnnotations().findAnnotation(OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME()) != null) break block12;
                        v3 = false;
                        break block11;
                    }
                    var11_13 = (ConstantValue)superClassAnnotation.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
                    if (var11_13 == null) ** GOTO lbl-1000
                    $this$safeAs$iv = var11_13;
                    $i$f$safeAs = false;
                    v4 = $this$safeAs$iv;
                    if (!(v4 instanceof KClassValue)) {
                        v4 = null;
                    }
                    if ((var14_16 = (KClassValue)v4) != null && (var12_14 = var14_16.getArgumentType(DescriptorUtilsKt.getModule((DeclarationDescriptor)superClassDescriptor))) != null) {
                        v5 = FqNameUtilKt.getFqName(var12_14);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = null;
                    }
                    apiFqName = v5;
                    v3 = Intrinsics.areEqual(apiFqName, (Object)annotationFqName);
                }
                if (!v3) continue;
                v1 = true;
                break block8;
            }
            v1 = false;
        }
        return v1;
    }

    private final KtAnnotationEntry findFileAnnotation(KtFile file2, FqName annotationFqName) {
        KtAnnotationEntry ktAnnotationEntry;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)file2, BodyResolveMode.PARTIAL);
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = object.getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)entry);
                    if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)annotationFqName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    public final boolean annotationExists(@NotNull ModuleDescriptor $this$annotationExists, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)$this$annotationExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)$this$annotationExists, (FqName)fqName2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)) != null;
    }

    private static final void doCreateActions$collectQuickFixes(BindingContext context2, List<IntentionAction> result2, boolean isOverrideError, FqName annotationFqName, FqName optInFqName, Set<? extends KotlinTarget> applicableTargets, KtDeclaration declaration2, AddAnnotationFix.Kind kind2) {
        boolean bl;
        block4: {
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            List actualTargetList = AnnotationChecker.Companion.getDeclarationSiteActualTargetList((KtElement)declaration2, declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null, context2);
            Iterable $this$any$iv = actualTargetList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)element$iv;
                    boolean bl2 = false;
                    if (!applicableTargets.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            result2.add(isOverrideError ? (PropagateOptInAnnotationFix)new HighPriorityPropagateOptInAnnotationFix(declaration2, annotationFqName, kind2, null, 8, null) : (INSTANCE.isSubclassOptPropagateApplicable(declaration2, annotationFqName) ? new PropagateOptInAnnotationFix(declaration2, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME(), kind2, annotationFqName, null, 16, null) : new PropagateOptInAnnotationFix(declaration2, annotationFqName, kind2, null, null, 24, null)));
        }
        KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)declaration2, optInFqName);
        SmartPsiElementPointer existingAnnotationEntry = ktAnnotationEntry != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktAnnotationEntry)) : null;
        result2.add(isOverrideError ? new UseOptInAnnotationFix(declaration2, optInFqName, kind2, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)existingAnnotationEntry) : (UseOptInAnnotationFix)new HighPriorityUseOptInAnnotationFix(declaration2, optInFqName, kind2, annotationFqName, (SmartPsiElementPointer<KtAnnotationEntry>)existingAnnotationEntry));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$HighPriorityPropagateOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$PropagateOptInAnnotationFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lcom/intellij/psi/SmartPsiElementPointer;)V", "kotlin.idea"})
    private static final class HighPriorityPropagateOptInAnnotationFix
    extends PropagateOptInAnnotationFix
    implements HighPriorityAction {
        public HighPriorityPropagateOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull FqName annotationFqName, @NotNull AddAnnotationFix.Kind kind2, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            super(element3, annotationFqName, kind2, null, existingAnnotationEntry);
        }

        public /* synthetic */ HighPriorityPropagateOptInAnnotationFix(KtDeclaration ktDeclaration, FqName fqName2, AddAnnotationFix.Kind kind2, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, fqName2, kind2, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$HighPriorityUseOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$UseOptInAnnotationFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "optInFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "kotlin.idea"})
    private static final class HighPriorityUseOptInAnnotationFix
    extends UseOptInAnnotationFix
    implements HighPriorityAction {
        public HighPriorityUseOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull FqName optInFqName, @NotNull AddAnnotationFix.Kind kind2, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)optInFqName, (String)"optInFqName");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super(element3, optInFqName, kind2, argumentClassFqName, existingAnnotationEntry);
        }

        public /* synthetic */ HighPriorityUseOptInAnnotationFix(KtDeclaration ktDeclaration, FqName fqName2, AddAnnotationFix.Kind kind2, FqName fqName3, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, fqName2, kind2, fqName3, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$LowPriorityMakeModuleOptInFix;", "Lorg/jetbrains/kotlin/idea/quickfix/MakeModuleOptInFix;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lcom/intellij/openapi/module/Module;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/name/FqName;)V", "kotlin.idea"})
    private static final class LowPriorityMakeModuleOptInFix
    extends MakeModuleOptInFix
    implements LowPriorityAction {
        public LowPriorityMakeModuleOptInFix(@NotNull KtFile file2, @NotNull Module module2, @NotNull FqName annotationFqName) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            super(file2, module2, annotationFqName);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$PropagateOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "", "getText", "kotlin.idea"})
    private static class PropagateOptInAnnotationFix
    extends AddAnnotationFix {
        @NotNull
        private final FqName annotationFqName;
        @NotNull
        private final AddAnnotationFix.Kind kind;
        @Nullable
        private final FqName argumentClassFqName;

        public PropagateOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull FqName annotationFqName, @NotNull AddAnnotationFix.Kind kind2, @Nullable FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            super((KtModifierListOwner)element3, annotationFqName, AddAnnotationFix.Kind.Self.INSTANCE, argumentClassFqName, existingAnnotationEntry);
            this.annotationFqName = annotationFqName;
            this.kind = kind2;
            this.argumentClassFqName = argumentClassFqName;
        }

        public /* synthetic */ PropagateOptInAnnotationFix(KtDeclaration ktDeclaration, FqName fqName2, AddAnnotationFix.Kind kind2, FqName fqName3, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                fqName3 = null;
            }
            if ((n & 0x10) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, fqName2, kind2, fqName3, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }

        @Override
        @NotNull
        public String getText() {
            String string2;
            String string3 = this.annotationFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"annotationFqName.shortName().asString()");
            String annotationName = string3;
            String annotationEntry2 = this.argumentClassFqName != null ? "(" + this.argumentClassFqName.shortName().asString() + "::class)" : "";
            String argumentText2 = annotationName + annotationEntry2;
            AddAnnotationFix.Kind kind2 = this.kind;
            if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Self.INSTANCE)) {
                Object[] objectArray = new Object[]{argumentText2, "?"};
                string2 = KotlinBundle.message("fix.opt_in.text.propagate.declaration", objectArray);
            } else if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Constructor.INSTANCE)) {
                Object[] objectArray = new Object[]{argumentText2};
                string2 = KotlinBundle.message("fix.opt_in.text.propagate.constructor", objectArray);
            } else if (kind2 instanceof AddAnnotationFix.Kind.Declaration) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string4 = ((AddAnnotationFix.Kind.Declaration)this.kind).getName();
                if (string4 == null) {
                    string4 = "?";
                }
                objectArray[1] = string4;
                string2 = KotlinBundle.message("fix.opt_in.text.propagate.declaration", objectArray);
            } else if (kind2 instanceof AddAnnotationFix.Kind.ContainingClass) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string5 = ((AddAnnotationFix.Kind.ContainingClass)this.kind).getName();
                if (string5 == null) {
                    string5 = "?";
                }
                objectArray[1] = string5;
                string2 = KotlinBundle.message("fix.opt_in.text.propagate.containing.class", objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.opt_in.annotation.family", new Object[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$UseOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "optInFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "elementName", "", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "getFamilyName", "getText", "kotlin.idea"})
    private static class UseOptInAnnotationFix
    extends AddAnnotationFix {
        @NotNull
        private final AddAnnotationFix.Kind kind;
        @NotNull
        private final FqName argumentClassFqName;
        @NotNull
        private final String elementName;

        public UseOptInAnnotationFix(@NotNull KtDeclaration element3, @NotNull FqName optInFqName, @NotNull AddAnnotationFix.Kind kind2, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)optInFqName, (String)"optInFqName");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super((KtModifierListOwner)element3, optInFqName, kind2, argumentClassFqName, existingAnnotationEntry);
            this.kind = kind2;
            this.argumentClassFqName = argumentClassFqName;
            String string2 = element3.getName();
            if (string2 == null) {
                string2 = "?";
            }
            this.elementName = string2;
        }

        public /* synthetic */ UseOptInAnnotationFix(KtDeclaration ktDeclaration, FqName fqName2, AddAnnotationFix.Kind kind2, FqName fqName3, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                smartPsiElementPointer = null;
            }
            this(ktDeclaration, fqName2, kind2, fqName3, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
        }

        @Override
        @NotNull
        public String getText() {
            String string2;
            String string3 = this.argumentClassFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"argumentClassFqName.shortName().asString()");
            String argumentText2 = string3;
            AddAnnotationFix.Kind kind2 = this.kind;
            if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Self.INSTANCE)) {
                Object[] objectArray = new Object[]{argumentText2, this.elementName};
                string2 = KotlinBundle.message("fix.opt_in.text.use.declaration", objectArray);
            } else if (Intrinsics.areEqual((Object)kind2, (Object)AddAnnotationFix.Kind.Constructor.INSTANCE)) {
                Object[] objectArray = new Object[]{argumentText2};
                string2 = KotlinBundle.message("fix.opt_in.text.use.constructor", objectArray);
            } else if (kind2 instanceof AddAnnotationFix.Kind.Declaration) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string4 = ((AddAnnotationFix.Kind.Declaration)this.kind).getName();
                if (string4 == null) {
                    string4 = "?";
                }
                objectArray[1] = string4;
                string2 = KotlinBundle.message("fix.opt_in.text.use.declaration", objectArray);
            } else if (kind2 instanceof AddAnnotationFix.Kind.ContainingClass) {
                Object[] objectArray = new Object[2];
                objectArray[0] = argumentText2;
                String string5 = ((AddAnnotationFix.Kind.ContainingClass)this.kind).getName();
                if (string5 == null) {
                    string5 = "?";
                }
                objectArray[1] = string5;
                string2 = KotlinBundle.message("fix.opt_in.text.use.containing.class", objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.opt_in.annotation.family", new Object[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory$UseOptInFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "optInFqName", "Lorg/jetbrains/kotlin/name/FqName;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "fileName", "", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "kotlin.idea"})
    private static class UseOptInFileAnnotationFix
    extends AddFileAnnotationFix {
        @NotNull
        private final FqName argumentClassFqName;
        @NotNull
        private final String fileName;

        public UseOptInFileAnnotationFix(@NotNull KtFile file2, @NotNull FqName optInFqName, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)optInFqName, (String)"optInFqName");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            super(file2, optInFqName, argumentClassFqName, existingAnnotationEntry);
            this.argumentClassFqName = argumentClassFqName;
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            this.fileName = string2;
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = this.argumentClassFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"argumentClassFqName.shortName().asString()");
            String argumentText2 = string2;
            Object[] objectArray = new Object[]{argumentText2, this.fileName};
            return KotlinBundle.message("fix.opt_in.text.use.containing.file", objectArray);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.opt_in.annotation.family", new Object[0]);
        }
    }
}

