/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.usagesSearch.operators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.OperatorReferenceSearcher;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/UnaryOperatorReferenceSearcher;", "Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher;", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "targetFunction", "Lcom/intellij/psi/PsiElement;", "operationToken", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "optimizer", "Lcom/intellij/psi/search/SearchRequestCollector;", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;Lcom/intellij/psi/search/SearchScope;Lcom/intellij/util/Processor;Lcom/intellij/psi/search/SearchRequestCollector;Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;)V", "extractReference", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isReferenceToCheck", "", "ref", "processPossibleReceiverExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nUnaryOperatorReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnaryOperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/UnaryOperatorReferenceSearcher\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,52:1\n40#2,2:53\n*S KotlinDebug\n*F\n+ 1 UnaryOperatorReferenceSearcher.kt\norg/jetbrains/kotlin/idea/search/usagesSearch/operators/UnaryOperatorReferenceSearcher\n*L\n50#1:53,2\n*E\n"})
public final class UnaryOperatorReferenceSearcher
extends OperatorReferenceSearcher<KtUnaryExpression> {
    @NotNull
    private final KtSingleValueToken operationToken;

    public UnaryOperatorReferenceSearcher(@NotNull PsiElement targetFunction, @NotNull KtSingleValueToken operationToken, @NotNull SearchScope searchScope2, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchRequestCollector optimizer, @NotNull KotlinReferencesSearchOptions options2) {
        Intrinsics.checkNotNullParameter((Object)targetFunction, (String)"targetFunction");
        Intrinsics.checkNotNullParameter((Object)operationToken, (String)"operationToken");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)optimizer, (String)"optimizer");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        super(targetFunction, searchScope2, consumer, optimizer, options2, CollectionsKt.listOf((Object)operationToken.getValue()));
        this.operationToken = operationToken;
    }

    @Override
    protected void processPossibleReceiverExpression(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        PsiElement psiElement2 = expression2.getParent();
        KtUnaryExpression ktUnaryExpression = psiElement2 instanceof KtUnaryExpression ? (KtUnaryExpression)psiElement2 : null;
        if (ktUnaryExpression == null) {
            return;
        }
        KtUnaryExpression unaryExpression = ktUnaryExpression;
        if (!Intrinsics.areEqual((Object)unaryExpression.getOperationToken(), (Object)this.operationToken)) {
            return;
        }
        this.processReferenceElement((KtElement)unaryExpression);
    }

    @Override
    protected boolean isReferenceToCheck(@NotNull PsiReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (!(ref instanceof KtSimpleNameReference)) {
            return false;
        }
        PsiElement psiElement2 = ((KtSimpleNameReference)ref).getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"ref.element");
        KtSimpleNameExpression element3 = (KtSimpleNameExpression)psiElement2;
        if (!(element3.getParent() instanceof KtUnaryExpression)) {
            return false;
        }
        return Intrinsics.areEqual((Object)element3.getReferencedNameElementType(), (Object)this.operationToken);
    }

    @Override
    @Nullable
    protected PsiReference extractReference(@NotNull KtElement element3) {
        Object element$iv2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            KtUnaryExpression ktUnaryExpression = element3 instanceof KtUnaryExpression ? (KtUnaryExpression)element3 : null;
            if (ktUnaryExpression == null) {
                return null;
            }
            KtUnaryExpression unaryExpression = ktUnaryExpression;
            if (!Intrinsics.areEqual((Object)unaryExpression.getOperationToken(), (Object)this.operationToken)) {
                return null;
            }
            PsiReference[] psiReferenceArray = unaryExpression.getOperationReference().getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"unaryExpression.operationReference.references");
            Object[] $this$firstIsInstance$iv = psiReferenceArray;
            boolean $i$f$firstIsInstance = false;
            for (Object element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KtSimpleNameReference)) {
                    continue;
                }
                break block4;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        return (PsiReference)element$iv2;
    }
}

