/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.teamcity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.TestCaseLoader;
import com.intellij.nastradamus.model.ChangeEntity;
import com.intellij.teamcity.TeamCityClient;
import com.intellij.tool.ErrorThresholdKt;
import com.intellij.tool.HttpClient;
import com.intellij.tool.NastradamusCache;
import com.intellij.tool.RetryKt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202J \u0010/\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202H\u0002J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0003J\u0006\u00106\u001a\u000204J\u0010\u00106\u001a\u0002042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\nJ\f\u0010;\u001a\b\u0012\u0004\u0012\u00020408J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u000204082\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\n2\b\b\u0002\u0010>\u001a\u000202H\u0002J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020408J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u000204082\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010@\u001a\u000204J\u0010\u0010@\u001a\u0002042\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010B\u001a\u00020\u0005H\u0002J\u001b\u0010C\u001a\u0002HD\"\b\b\u0000\u0010D*\u00020E*\u0002HDH\u0002\u00a2\u0006\u0002\u0010FR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR'\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0018\u0010\fR\u001d\u0010\u001a\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001b\u0010\fR\u0019\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\bR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000e\u001a\u0004\b#\u0010\fR\u001b\u0010%\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000e\u001a\u0004\b&\u0010\fR\u0016\u0010(\u001a\n \u001e*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u000e\u001a\u0004\b*\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010,\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000e\u001a\u0004\b-\u0010\f\u00a8\u0006G"}, d2={"Lcom/intellij/teamcity/TeamCityClient;", "", "baseUri", "Ljava/net/URI;", "systemPropertiesFilePath", "Ljava/nio/file/Path;", "(Ljava/net/URI;Ljava/nio/file/Path;)V", "getBaseUri", "()Ljava/net/URI;", "buildId", "", "getBuildId", "()Ljava/lang/String;", "buildId$delegate", "Lkotlin/Lazy;", "buildNumber", "getBuildNumber", "buildNumber$delegate", "buildParams", "", "getBuildParams", "()Ljava/util/Map;", "buildParams$delegate", "buildTypeId", "getBuildTypeId", "buildTypeId$delegate", "configurationName", "getConfigurationName", "configurationName$delegate", "guestAuthUri", "kotlin.jvm.PlatformType", "getGuestAuthUri", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "os", "getOs", "os$delegate", "password", "getPassword", "password$delegate", "restUri", "systemProperties", "getSystemProperties", "systemProperties$delegate", "userName", "getUserName", "userName$delegate", "downloadChangesPatch", "modificationId", "isPersonal", "", "get", "Lcom/fasterxml/jackson/databind/JsonNode;", "fullUrl", "getBuildInfo", "getChangeDetails", "", "Lcom/intellij/nastradamus/model/ChangeEntity;", "changeId", "getChanges", "getExistingParameter", "name", "impreciseNameMatch", "getTestRunInfo", "getTriggeredByInfo", "loadProperties", "propertiesPath", "withAuth", "T", "Lorg/apache/http/HttpRequest;", "(Lorg/apache/http/HttpRequest;)Lorg/apache/http/HttpRequest;", "intellij.platform.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nTeamCityClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityClient.kt\ncom/intellij/teamcity/TeamCityClient\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n515#2:240\n500#2,6:241\n1#3:247\n1549#4:248\n1620#4,3:249\n*S KotlinDebug\n*F\n+ 1 TeamCityClient.kt\ncom/intellij/teamcity/TeamCityClient\n*L\n71#1:240\n71#1:241,6\n172#1:248\n172#1:249,3\n*E\n"})
public final class TeamCityClient {
    @NotNull
    private final URI baseUri;
    @NotNull
    private final Path systemPropertiesFilePath;
    @NotNull
    private final Lazy systemProperties$delegate;
    private final URI restUri;
    private final URI guestAuthUri;
    @NotNull
    private final Lazy buildNumber$delegate;
    @NotNull
    private final Lazy configurationName$delegate;
    @NotNull
    private final Lazy buildParams$delegate;
    @NotNull
    private final Lazy buildId$delegate;
    @NotNull
    private final Lazy buildTypeId$delegate;
    @NotNull
    private final Lazy os$delegate;
    @NotNull
    private final Lazy userName$delegate;
    @NotNull
    private final Lazy password$delegate;
    @NotNull
    private final ObjectMapper jacksonMapper;

    public TeamCityClient(@NotNull URI baseUri, @NotNull Path systemPropertiesFilePath) {
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        Intrinsics.checkNotNullParameter((Object)systemPropertiesFilePath, (String)"systemPropertiesFilePath");
        this.baseUri = baseUri;
        this.systemPropertiesFilePath = systemPropertiesFilePath;
        this.systemProperties$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, String> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map map = TeamCityClient.access$loadProperties(this.this$0, TeamCityClient.access$getSystemPropertiesFilePath$p(this.this$0));
                Properties properties = System.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties()");
                Map map2 = properties;
                Map map3 = map;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it.getKey().toString(), (Object)it.getValue().toString()));
                }
                return MapsKt.plus((Map)map3, (Iterable)((List)destination$iv$iv));
            }
        }));
        this.restUri = this.baseUri.resolve("/app/rest/");
        this.guestAuthUri = this.baseUri.resolve("/guestAuth/app/rest/");
        this.buildNumber$delegate = LazyKt.lazy((Function0)buildNumber.2.INSTANCE);
        this.configurationName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return (String)TeamCityClient.access$getSystemProperties(this.this$0).get("teamcity.buildConfName");
            }
        }));
        this.buildParams$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                String configurationPropertiesFile = (String)TeamCityClient.access$getSystemProperties(this.this$0).get("teamcity.configuration.properties.file");
                CharSequence charSequence = configurationPropertiesFile;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return MapsKt.emptyMap();
                }
                Path path = Paths.get(configurationPropertiesFile, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
                return TeamCityClient.access$loadProperties(this.this$0, path);
            }
        }));
        this.buildId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TeamCityClient.getExistingParameter$default(this.this$0, "teamcity.build.id", false, 2, null);
            }
        }));
        this.buildTypeId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TeamCityClient.getExistingParameter$default(this.this$0, "teamcity.buildType.id", false, 2, null);
            }
        }));
        this.os$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TeamCityClient.getExistingParameter$default(this.this$0, "teamcity.agent.jvm.os.name", false, 2, null);
            }
        }));
        this.userName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TeamCityClient.getExistingParameter$default(this.this$0, "teamcity.auth.userId", false, 2, null);
            }
        }));
        this.password$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TeamCityClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return TeamCityClient.getExistingParameter$default(this.this$0, "teamcity.auth.password", false, 2, null);
            }
        }));
        this.jacksonMapper = ExtensionsKt.jacksonObjectMapper();
    }

    public /* synthetic */ TeamCityClient(URI uRI, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = new URI("https://buildserver.labs.intellij.net").normalize();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"URI(\"https://buildserver\u2026ntellij.net\").normalize()");
            uRI = uRI2;
        }
        if ((n & 2) != 0) {
            String string = System.getenv("TEAMCITY_BUILD_PROPERTIES_FILE");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(\"TEAMCITY_BUILD_PROPERTIES_FILE\")");
            Path path2 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            path = path2;
        }
        this(uRI, path);
    }

    @NotNull
    public final URI getBaseUri() {
        return this.baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> loadProperties(Path propertiesPath) {
        Object object;
        try {
            Map map;
            object = propertiesPath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                Map map2 = new LinkedHashMap();
                Properties ps = new Properties();
                ps.load(it);
                ps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> TeamCityClient.loadProperties$lambda$1$lambda$0(map2, arg_0, arg_1)));
                map = map2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = map;
        }
        catch (Throwable t) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final Map<String, String> getSystemProperties() {
        Lazy lazy = this.systemProperties$delegate;
        return (Map)lazy.getValue();
    }

    public final URI getGuestAuthUri() {
        return this.guestAuthUri;
    }

    @NotNull
    public final String getBuildNumber() {
        Lazy lazy = this.buildNumber$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getConfigurationName() {
        Lazy lazy = this.configurationName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Map<String, String> getBuildParams() {
        Lazy lazy = this.buildParams$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final String getExistingParameter(String name, boolean impreciseNameMatch) {
        String paramValue;
        String string;
        Map totalParams = MapsKt.plus(this.getSystemProperties(), this.getBuildParams());
        if (impreciseNameMatch) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = totalParams;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((CharSequence)it.getKey()), (CharSequence)name, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map paramCandidates = destination$iv$iv;
            if (paramCandidates.size() > 1) {
                System.err.println("Found many parameters matching " + name + ". Candidates: " + paramCandidates);
            }
            string = (String)paramCandidates.get(MapsKt.toSortedMap((Map)paramCandidates).firstKey());
        } else {
            string = (String)totalParams.get(name);
        }
        String string2 = paramValue = string;
        if (string2 == null) {
            throw new IllegalStateException(("Parameter " + name + " is not specified in the build!").toString());
        }
        return string2;
    }

    static /* synthetic */ String getExistingParameter$default(TeamCityClient teamCityClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return teamCityClient.getExistingParameter(string, bl);
    }

    @NotNull
    public final String getBuildId() {
        Lazy lazy = this.buildId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getBuildTypeId() {
        Lazy lazy = this.buildTypeId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getOs() {
        Lazy lazy = this.os$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserName() {
        Lazy lazy = this.userName$delegate;
        return (String)lazy.getValue();
    }

    private final String getPassword() {
        Lazy lazy = this.password$delegate;
        return (String)lazy.getValue();
    }

    private final <T extends HttpRequest> T withAuth(T $this$withAuth) {
        T t;
        T $this$withAuth_u24lambda_u243 = t = $this$withAuth;
        boolean bl = false;
        $this$withAuth_u24lambda_u243.addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(this.getUserName(), this.getPassword()), $this$withAuth_u24lambda_u243, null));
        return t;
    }

    @NotNull
    public final JsonNode get(@NotNull URI fullUrl) {
        JsonNode result2;
        HttpGet httpGet;
        Intrinsics.checkNotNullParameter((Object)fullUrl, (String)"fullUrl");
        HttpGet $this$get_u24lambda_u244 = httpGet = new HttpGet(fullUrl);
        boolean bl = false;
        $this$get_u24lambda_u244.addHeader("Content-Type", "application/json");
        $this$get_u24lambda_u244.addHeader("Accept", "application/json");
        this.withAuth((HttpRequest)$this$get_u24lambda_u244);
        HttpGet request = httpGet;
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Request to TeamCity: " + fullUrl));
        }
        JsonNode jsonNode = result2 = (JsonNode)ErrorThresholdKt.withErrorThreshold$default("TeamCityClient-get", 0, (Function0)new Function0<JsonNode>(request, this){
            final /* synthetic */ HttpGet $request;
            final /* synthetic */ TeamCityClient this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final JsonNode invoke() {
                return (JsonNode)RetryKt.withRetry-exY8QGI$default(0, null, 0L, (Function0)new Function0<JsonNode>(this.$request, this.this$0){
                    final /* synthetic */ HttpGet $request;
                    final /* synthetic */ TeamCityClient this$0;
                    {
                        this.$request = $request;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final JsonNode invoke() {
                        return (JsonNode)HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$request, (Function1)new Function1<HttpResponse, JsonNode>(this.this$0){
                            final /* synthetic */ TeamCityClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final JsonNode invoke(@NotNull HttpResponse it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (it.getStatusLine().getStatusCode() != 200) {
                                    throw new RuntimeException(StringsKt.trimIndent((String)("\n                TeamCity returned not successful status code " + it.getStatusLine().getStatusCode() + ".\n                " + TextStreamsKt.readText((Reader)new InputStreamReader(it.getEntity().getContent())) + "\n                ")));
                                }
                                return TeamCityClient.access$getJacksonMapper$p(this.this$0).readTree(it.getEntity().getContent());
                            }
                        });
                    }
                }, 7, null);
            }
        }, (Function0)new Function0<JsonNode>(fullUrl){
            final /* synthetic */ URI $fullUrl;
            {
                this.$fullUrl = $fullUrl;
                super(0);
            }

            @Nullable
            public final JsonNode invoke() {
                throw new RuntimeException("Couldn't get data from TeamCity " + this.$fullUrl);
            }
        }, 2, null);
        if (jsonNode == null) {
            boolean bl2 = false;
            String string = "Request " + request.getURI() + " failed";
            throw new IllegalArgumentException(string.toString());
        }
        return jsonNode;
    }

    private final String downloadChangesPatch(String buildTypeId2, String modificationId, boolean isPersonal) {
        URI uri = this.baseUri.resolve("/downloadPatch.html?buildTypeId=" + buildTypeId2 + "&modId=" + modificationId + "&personal=" + isPersonal);
        return NastradamusCache.INSTANCE.get(uri, (Function0<String>)((Function0)new Function0<String>(this, uri){
            final /* synthetic */ TeamCityClient this$0;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(0);
            }

            @NotNull
            public final String invoke() {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                if (!HttpClient.INSTANCE.download((HttpUriRequest)TeamCityClient.access$withAuth(this.this$0, (HttpRequest)new HttpGet(this.$uri)), outputStream, 3)) {
                    throw new RuntimeException("Couldn't download patch " + this.$uri + " in 3 attempts");
                }
                String string = outputStream.toString("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputStream.toString(\"UTF-8\")");
                return string;
            }
        }));
    }

    @NotNull
    public final String downloadChangesPatch(@NotNull String modificationId, boolean isPersonal) {
        Intrinsics.checkNotNullParameter((Object)modificationId, (String)"modificationId");
        return this.downloadChangesPatch(this.getBuildTypeId(), modificationId, isPersonal);
    }

    @NotNull
    public final List<JsonNode> getChanges(@NotNull String buildId2) {
        Intrinsics.checkNotNullParameter((Object)buildId2, (String)"buildId");
        URI fullUrl = this.restUri.resolve("changes?locator=build:(id:" + buildId2 + ")");
        String rawData2 = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)new Function0<String>(this, fullUrl){
            final /* synthetic */ TeamCityClient this$0;
            final /* synthetic */ URI $fullUrl;
            {
                this.this$0 = $receiver;
                this.$fullUrl = $fullUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                URI uRI = this.$fullUrl;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fullUrl");
                String string = this.this$0.get(uRI).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(fullUrl).toString()");
                return string;
            }
        }));
        Iterator iterator = this.jacksonMapper.readTree(rawData2).fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jacksonMapper.readTree(rawData).fields()");
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getChanges.1.INSTANCE), (Function1)getChanges.2.INSTANCE));
    }

    @NotNull
    public final List<JsonNode> getChanges() {
        return this.getChanges(this.getBuildId());
    }

    @NotNull
    public final List<ChangeEntity> getChangeDetails(@NotNull String changeId) {
        Intrinsics.checkNotNullParameter((Object)changeId, (String)"changeId");
        URI fullUrl = this.restUri.resolve("changes/id:" + changeId);
        String rawChange2 = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)new Function0<String>(this, fullUrl){
            final /* synthetic */ TeamCityClient this$0;
            final /* synthetic */ URI $fullUrl;
            {
                this.this$0 = $receiver;
                this.$fullUrl = $fullUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                URI uRI = this.$fullUrl;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fullUrl");
                String string = this.this$0.get(uRI).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(fullUrl).toString()");
                return string;
            }
        }));
        JsonNode jsonNode = this.jacksonMapper.readTree(rawChange2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"jacksonMapper.readTree(rawChange)");
        return TeamCityClient.getChangeDetails$processData(jsonNode);
    }

    @NotNull
    public final List<JsonNode> getTestRunInfo(@NotNull String buildId2) {
        Intrinsics.checkNotNullParameter((Object)buildId2, (String)"buildId");
        int countOfTestsOnPage = 200;
        int startPosition = 0;
        List accumulatedTests = new ArrayList();
        List currentTests = null;
        System.out.println((Object)"Getting test run info from TC ...");
        do {
            URI fullUrl = this.restUri.resolve("testOccurrences?locator=build:(id:" + buildId2 + "),ignored:any,muted:any,count:" + countOfTestsOnPage + ",start:" + startPosition + ",includePersonal:true&fields=nextHref,testOccurrence(id,name,status,duration,currentlyInvestigated,currentlyMuted,muted,test(id,parsedTestName),newFailure,metadata(count),nextFixed(id),runOrder)");
            String rawData2 = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)new Function0<String>(this, fullUrl){
                final /* synthetic */ TeamCityClient this$0;
                final /* synthetic */ URI $fullUrl;
                {
                    this.this$0 = $receiver;
                    this.$fullUrl = $fullUrl;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    URI uRI = this.$fullUrl;
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fullUrl");
                    String string = this.this$0.get(uRI).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(fullUrl).toString()");
                    return string;
                }
            }));
            Iterator iterator = this.jacksonMapper.readTree(rawData2).fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jacksonMapper.readTree(rawData).fields()");
            currentTests = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)getTestRunInfo.1.INSTANCE), (Function1)getTestRunInfo.2.INSTANCE));
            accumulatedTests.addAll(currentTests);
            startPosition += countOfTestsOnPage;
        } while (!((Collection)currentTests).isEmpty());
        System.out.println((Object)("Test run info acquired. Count of tests " + accumulatedTests.size()));
        return accumulatedTests;
    }

    @NotNull
    public final List<JsonNode> getTestRunInfo() {
        return this.getTestRunInfo(this.getBuildId());
    }

    private final JsonNode getBuildInfo(String buildId2) {
        URI fullUrl = this.restUri.resolve("builds/" + buildId2);
        String rawData2 = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)new Function0<String>(this, fullUrl){
            final /* synthetic */ TeamCityClient this$0;
            final /* synthetic */ URI $fullUrl;
            {
                this.this$0 = $receiver;
                this.$fullUrl = $fullUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                URI uRI = this.$fullUrl;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fullUrl");
                String string = this.this$0.get(uRI).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(fullUrl).toString()");
                return string;
            }
        }));
        JsonNode jsonNode = this.jacksonMapper.readTree(rawData2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"jacksonMapper.readTree(rawData)");
        return jsonNode;
    }

    @NotNull
    public final JsonNode getBuildInfo() {
        return this.getBuildInfo(this.getBuildId());
    }

    private final JsonNode getTriggeredByInfo(String buildId2) {
        JsonNode jsonNode = this.getBuildInfo(buildId2).findValue("triggered");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"getBuildInfo(buildId).findValue(\"triggered\")");
        return jsonNode;
    }

    @NotNull
    public final JsonNode getTriggeredByInfo() {
        return this.getTriggeredByInfo(this.getBuildId());
    }

    private static final void loadProperties$lambda$1$lambda$0(Map $map, Object k, Object v) {
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        if (k != null && v != null) {
            $map.put(k.toString(), v.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ChangeEntity> getChangeDetails$processData(JsonNode jsonRoot) {
        void $this$mapTo$iv$iv;
        String comment = jsonRoot.findValue("comment").asText();
        String userName2 = jsonRoot.findValue("username").asText();
        String date = jsonRoot.findValue("date").asText();
        JsonNode jsonNode = jsonRoot.findValue("files").findValue("file");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"jsonRoot.findValue(\"file\u2026       .findValue(\"file\")");
        List filesFields = CollectionsKt.toList((Iterable)((Iterable)jsonNode));
        Iterable $this$map$iv = filesFields;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            String string3;
            void fileField;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string4 = fileField.findValue("file").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fileField.findValue(\"file\").asText()");
            String string5 = fileField.findValue("relative-file").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"fileField.findValue(\"relative-file\").asText()");
            JsonNode jsonNode3 = fileField.findValue("before-revision");
            String string6 = string3 = jsonNode3 != null ? jsonNode3.asText("") : null;
            if (string6 == null) {
                string2 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"fileField.findValue(\"bef\u2026ision\")?.asText(\"\") ?: \"\"");
                string2 = string3;
            }
            JsonNode jsonNode4 = fileField.findValue("after-revision");
            String string7 = string3 = jsonNode4 != null ? jsonNode4.asText("") : null;
            if (string7 == null) {
                string = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"fileField.findValue(\"aft\u2026ision\")?.asText(\"\") ?: \"\"");
                string = string3;
            }
            String string8 = fileField.findValue("changeType").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"fileField.findValue(\"changeType\").asText()");
            Intrinsics.checkNotNullExpressionValue((Object)comment, (String)"comment");
            Intrinsics.checkNotNullExpressionValue((Object)userName2, (String)"userName");
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
            collection.add(new ChangeEntity(string4, string5, string2, string, string8, comment, userName2, date));
        }
        return (List)destination$iv$iv;
    }

    public TeamCityClient() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ ObjectMapper access$getJacksonMapper$p(TeamCityClient $this) {
        return $this.jacksonMapper;
    }

    public static final /* synthetic */ HttpRequest access$withAuth(TeamCityClient $this, HttpRequest $receiver) {
        return $this.withAuth($receiver);
    }

    public static final /* synthetic */ Map access$loadProperties(TeamCityClient $this, Path propertiesPath) {
        return $this.loadProperties(propertiesPath);
    }

    public static final /* synthetic */ Path access$getSystemPropertiesFilePath$p(TeamCityClient $this) {
        return $this.systemPropertiesFilePath;
    }

    public static final /* synthetic */ Map access$getSystemProperties(TeamCityClient $this) {
        return $this.getSystemProperties();
    }
}

