/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Function;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class TreeNodeTester {
    private final TreeNode myNode;
    private Function<? super TreeNode, String> myPresenter = Object::toString;

    public static TreeNodeTester forNode(TreeNode node2) {
        return new TreeNodeTester(node2);
    }

    private TreeNodeTester(TreeNode node2) {
        this.myNode = node2;
    }

    public TreeNodeTester withPresenter(Function<? super TreeNode, String> presenter) {
        this.myPresenter = presenter;
        return this;
    }

    @NotNull
    public String constructTextRepresentation() {
        StringBuilder buffer = new StringBuilder();
        this.printSubTree(this.myNode, 0, buffer);
        String string = buffer.toString();
        if (string == null) {
            TreeNodeTester.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void assertStructureEquals(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.constructTextRepresentation());
    }

    private void printSubTree(TreeNode node2, int level, StringBuilder result2) {
        result2.append(StringUtil.repeat((String)" ", (int)level)).append(this.myPresenter.apply(node2)).append("\n");
        for (int i2 = 0; i2 < node2.getChildCount(); ++i2) {
            this.printSubTree(node2.getChildAt(i2), level + 1, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TreeNodeTester", "constructTextRepresentation"));
    }
}

