/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextAttributes {
    public static ContextAttributes getEmpty() {
        return Impl.getEmpty();
    }

    public abstract ContextAttributes withSharedAttribute(Object var1, Object var2);

    public abstract ContextAttributes withSharedAttributes(Map<?, ?> var1);

    public abstract ContextAttributes withoutSharedAttribute(Object var1);

    public abstract Object getAttribute(Object var1);

    public abstract ContextAttributes withPerCallAttribute(Object var1, Object var2);

    public static class Impl
    extends ContextAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Impl EMPTY = new Impl(Collections.emptyMap());
        protected static final Object NULL_SURROGATE = new Object();
        protected final Map<?, ?> _shared;
        protected transient Map<Object, Object> _nonShared;

        protected Impl(Map<?, ?> shared) {
            this._shared = shared;
            this._nonShared = null;
        }

        protected Impl(Map<?, ?> shared, Map<Object, Object> nonShared) {
            this._shared = shared;
            this._nonShared = nonShared;
        }

        public static ContextAttributes getEmpty() {
            return EMPTY;
        }

        @Override
        public ContextAttributes withSharedAttribute(Object key, Object value2) {
            Map<Object, Object> m3 = this == EMPTY ? new HashMap(8) : this._copy(this._shared);
            m3.put(key, value2);
            return new Impl(m3);
        }

        @Override
        public ContextAttributes withSharedAttributes(Map<?, ?> shared) {
            return new Impl(shared);
        }

        @Override
        public ContextAttributes withoutSharedAttribute(Object key) {
            if (this._shared.isEmpty()) {
                return this;
            }
            if (this._shared.containsKey(key)) {
                if (this._shared.size() == 1) {
                    return EMPTY;
                }
            } else {
                return this;
            }
            Map<Object, Object> m3 = this._copy(this._shared);
            m3.remove(key);
            return new Impl(m3);
        }

        @Override
        public Object getAttribute(Object key) {
            Object ob;
            if (this._nonShared != null && (ob = this._nonShared.get(key)) != null) {
                if (ob == NULL_SURROGATE) {
                    return null;
                }
                return ob;
            }
            return this._shared.get(key);
        }

        @Override
        public ContextAttributes withPerCallAttribute(Object key, Object value2) {
            if (value2 == null) {
                if (this._shared.containsKey(key)) {
                    value2 = NULL_SURROGATE;
                } else {
                    if (this._nonShared == null || !this._nonShared.containsKey(key)) {
                        return this;
                    }
                    this._nonShared.remove(key);
                    return this;
                }
            }
            if (this._nonShared == null) {
                return this.nonSharedInstance(key, value2);
            }
            this._nonShared.put(key, value2);
            return this;
        }

        protected ContextAttributes nonSharedInstance(Object key, Object value2) {
            HashMap<Object, Object> m3 = new HashMap<Object, Object>();
            if (value2 == null) {
                value2 = NULL_SURROGATE;
            }
            m3.put(key, value2);
            return new Impl(this._shared, m3);
        }

        private Map<Object, Object> _copy(Map<?, ?> src) {
            return new HashMap<Object, Object>(src);
        }
    }
}

