/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.colibri2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Error;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"createConferenceAlreadyExistsError", "Lorg/jivesoftware/smack/packet/IQ;", "iq", "conferenceId", "", "createConferenceNotFoundError", "createGracefulShutdownErrorResponse", "jitsi-videobridge"})
public final class Colibri2UtilKt {
    @NotNull
    public static final IQ createConferenceAlreadyExistsError(@NotNull IQ iq, @NotNull String conferenceId) {
        Intrinsics.checkNotNullParameter(iq, "iq");
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        return ErrorUtilKt.createError(iq, StanzaError.Condition.conflict, "Conference already exists for ID: " + conferenceId, new Colibri2Error(Colibri2Error.Reason.CONFERENCE_ALREADY_EXISTS));
    }

    @NotNull
    public static final IQ createConferenceNotFoundError(@NotNull IQ iq, @NotNull String conferenceId) {
        Intrinsics.checkNotNullParameter(iq, "iq");
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        return ErrorUtilKt.createError(iq, StanzaError.Condition.item_not_found, "Conference not found for ID: " + conferenceId, new Colibri2Error(Colibri2Error.Reason.CONFERENCE_NOT_FOUND));
    }

    @NotNull
    public static final IQ createGracefulShutdownErrorResponse(@NotNull IQ iq) {
        Intrinsics.checkNotNullParameter(iq, "iq");
        return ErrorUtilKt.createError(iq, StanzaError.Condition.service_unavailable, "In graceful shutdown", new Colibri2Error(Colibri2Error.Reason.GRACEFUL_SHUTDOWN));
    }
}

