/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator;

import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.RateControlInput;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.RateControlRegion;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.RateControlState;

class AimdRateControl {
    private static final TimeSeriesLogger logger = TimeSeriesLogger.getTimeSeriesLogger(AimdRateControl.class);
    private static final int kDefaultRttMs = 200;
    private static final long kInitializationTimeMs = 5000L;
    private static final long kFirstIncomingEstimateExpirationMs = 10000L;
    private static final long kLogIntervalMs = 1000L;
    private static final long kMaxFeedbackIntervalMs = 1000L;
    private static final long kMinFeedbackIntervalMs = 200L;
    private static final int kRtcpSize = 80;
    private static final double kWithinIncomingBitrateHysteresis = 1.05;
    private final DiagnosticContext diagnosticContext;
    private float avgMaxBitrateKbps;
    private float beta;
    private boolean bitrateIsInitialized;
    private int incomingBitrateExpirations = 0;
    private long currentBitrateBps;
    private final RateControlInput currentInput = new RateControlInput(BandwidthUsage.kBwNormal, 0L, 0.0);
    private boolean inExperiment;
    private long minConfiguredBitrateBps;
    private RateControlRegion rateControlRegion;
    private RateControlState rateControlState;
    private long rtt;
    private long timeFirstIncomingEstimate;
    private long timeLastBitrateChange;
    private long timeOfLastLog;
    private boolean updated;
    private float varMaxBitrateKbps;

    public AimdRateControl(@NotNull DiagnosticContext diagnosticContext) {
        this.reset();
        this.diagnosticContext = diagnosticContext;
    }

    private long additiveRateIncrease(long nowMs, long lastMs, long responseTimeMs) {
        if (responseTimeMs <= 0L) {
            throw new IllegalArgumentException("responseTimeMs");
        }
        double beta = 0.0;
        if (lastMs > 0L) {
            beta = Math.min((double)(nowMs - lastMs) / (double)responseTimeMs, 1.0);
            if (this.inExperiment) {
                beta /= 2.0;
            }
        }
        double bitsPerFrame = (double)this.currentBitrateBps / 30.0;
        double packetsPerFrame = Math.ceil(bitsPerFrame / 9600.0);
        double avgPacketSizeBits = bitsPerFrame / packetsPerFrame;
        return (long)Math.max(1000.0, beta * avgPacketSizeBits);
    }

    private long changeBitrate(long currentBitrateBps, long incomingBitrateBps, long nowMs) {
        if (!this.updated) {
            return this.currentBitrateBps;
        }
        if (!this.bitrateIsInitialized && this.currentInput.bwState != BandwidthUsage.kBwOverusing) {
            return this.currentBitrateBps;
        }
        this.updated = false;
        this.changeState(this.currentInput, nowMs);
        float incomingBitrateKbps = (float)incomingBitrateBps / 1000.0f;
        float stdMaxBitRate = (float)Math.sqrt(this.varMaxBitrateKbps * this.avgMaxBitrateKbps);
        switch (this.rateControlState) {
            case kRcHold: {
                break;
            }
            case kRcIncrease: {
                if (this.avgMaxBitrateKbps >= 0.0f && incomingBitrateKbps > this.avgMaxBitrateKbps + 3.0f * stdMaxBitRate) {
                    this.changeRegion(RateControlRegion.kRcMaxUnknown, nowMs);
                    this.avgMaxBitrateKbps = -1.0f;
                }
                if (this.rateControlRegion == RateControlRegion.kRcNearMax) {
                    long responseTime = this.rtt + 100L;
                    long additiveIncreaseBps = this.additiveRateIncrease(nowMs, this.timeLastBitrateChange, responseTime);
                    currentBitrateBps += additiveIncreaseBps;
                } else {
                    long multiplicativeIncreaseBps = this.multiplicativeRateIncrease(nowMs, this.timeLastBitrateChange, currentBitrateBps);
                    currentBitrateBps += multiplicativeIncreaseBps;
                }
                this.timeLastBitrateChange = nowMs;
                break;
            }
            case kRcDecrease: {
                this.bitrateIsInitialized = true;
                if (incomingBitrateBps < this.minConfiguredBitrateBps) {
                    currentBitrateBps = this.minConfiguredBitrateBps;
                } else {
                    currentBitrateBps = (long)((double)(this.beta * (float)incomingBitrateBps) + 0.5);
                    if (currentBitrateBps > this.currentBitrateBps) {
                        if (this.rateControlRegion != RateControlRegion.kRcMaxUnknown) {
                            currentBitrateBps = (long)(this.beta * this.avgMaxBitrateKbps * 1000.0f + 0.5f);
                        }
                        currentBitrateBps = Math.min(currentBitrateBps, this.currentBitrateBps);
                    }
                    this.changeRegion(RateControlRegion.kRcNearMax, nowMs);
                    if (incomingBitrateKbps < this.avgMaxBitrateKbps - 3.0f * stdMaxBitRate) {
                        this.avgMaxBitrateKbps = -1.0f;
                    }
                    this.updateMaxBitRateEstimate(incomingBitrateKbps);
                }
                this.changeState(RateControlState.kRcHold, nowMs);
                this.timeLastBitrateChange = nowMs;
                break;
            }
            default: {
                throw new IllegalStateException("rateControlState");
            }
        }
        if ((incomingBitrateBps > 100000L || currentBitrateBps > 150000L) && (double)currentBitrateBps > 1.5 * (double)incomingBitrateBps) {
            currentBitrateBps = this.currentBitrateBps;
            this.timeLastBitrateChange = nowMs;
        }
        return currentBitrateBps;
    }

    private void changeRegion(RateControlRegion region, long nowMs) {
        if (this.rateControlRegion == region) {
            return;
        }
        this.rateControlRegion = region;
        if (logger.isTraceEnabled()) {
            logger.trace(this.diagnosticContext.makeTimeSeriesPoint("aimd_region", nowMs).addField("aimd_id", this.hashCode()).addField("region", (Object)region));
        }
    }

    private void changeState(RateControlInput input, long nowMs) {
        switch (this.currentInput.bwState) {
            case kBwNormal: {
                if (this.rateControlState != RateControlState.kRcHold) break;
                this.timeLastBitrateChange = nowMs;
                this.changeState(RateControlState.kRcIncrease, nowMs);
                break;
            }
            case kBwOverusing: {
                if (this.rateControlState == RateControlState.kRcDecrease) break;
                this.changeState(RateControlState.kRcDecrease, nowMs);
                break;
            }
            case kBwUnderusing: {
                this.changeState(RateControlState.kRcHold, nowMs);
                break;
            }
            default: {
                throw new IllegalStateException("currentInput.bwState");
            }
        }
    }

    private void changeState(RateControlState newState, long nowMs) {
        if (this.rateControlState == newState) {
            return;
        }
        this.rateControlState = newState;
        if (logger.isTraceEnabled()) {
            logger.trace(this.diagnosticContext.makeTimeSeriesPoint("aimd_state", nowMs).addField("aimd_id", this.hashCode()).addField("state", (Object)this.rateControlState));
        }
    }

    public long getFeedBackInterval() {
        long interval2 = (long)(640000.0 / (0.05 * (double)this.currentBitrateBps) + 0.5);
        return Math.min(Math.max(interval2, 200L), 1000L);
    }

    public long getLatestEstimate() {
        return this.currentBitrateBps;
    }

    public boolean isTimeToReduceFurther(long timeNow, long incomingBitrateBps) {
        long bitrateReductionInterval = Math.max(Math.min(this.rtt, 200L), 10L);
        if (timeNow - this.timeLastBitrateChange >= bitrateReductionInterval) {
            return true;
        }
        if (this.isValidEstimate()) {
            long threshold = (long)(1.05 * (double)incomingBitrateBps);
            long bitrateDifference = this.getLatestEstimate() - incomingBitrateBps;
            return bitrateDifference > threshold;
        }
        return false;
    }

    public int getIncomingEstimateExpirations() {
        return this.incomingBitrateExpirations;
    }

    public boolean isValidEstimate() {
        return this.bitrateIsInitialized;
    }

    private long multiplicativeRateIncrease(long nowMs, long lastMs, long currentBitrateBps) {
        double alpha = 1.08;
        if (lastMs > -1L) {
            long timeSinceLastUpdateMs = Math.min(nowMs - lastMs, 1000L);
            alpha = Math.pow(alpha, (double)timeSinceLastUpdateMs / 1000.0);
        }
        return (long)Math.max((double)currentBitrateBps * (alpha - 1.0), 1000.0);
    }

    public void reset() {
        this.reset(30000L);
    }

    private void reset(long minBitrateBps) {
        this.minConfiguredBitrateBps = minBitrateBps;
        this.currentBitrateBps = 30000000L;
        this.avgMaxBitrateKbps = -1.0f;
        this.varMaxBitrateKbps = 0.4f;
        this.rateControlState = RateControlState.kRcHold;
        this.rateControlRegion = RateControlRegion.kRcMaxUnknown;
        this.timeLastBitrateChange = -1L;
        this.currentInput.bwState = BandwidthUsage.kBwNormal;
        this.currentInput.incomingBitRate = 0L;
        this.currentInput.noiseVar = 1.0;
        this.updated = false;
        this.timeFirstIncomingEstimate = -1L;
        this.bitrateIsInitialized = false;
        this.beta = 0.85f;
        this.rtt = 200L;
        this.timeOfLastLog = -1L;
        this.inExperiment = false;
    }

    public void setEstimate(long bitrateBps, long nowMs) {
        this.updated = true;
        this.bitrateIsInitialized = true;
        this.currentBitrateBps = this.changeBitrate(bitrateBps, bitrateBps, nowMs);
    }

    public void setMinBitrate(long minBitrateBps) {
        this.minConfiguredBitrateBps = minBitrateBps;
        this.currentBitrateBps = Math.max(minBitrateBps, this.currentBitrateBps);
    }

    public void setRtt(long nowMs, long rtt) {
        if (logger.isTraceEnabled()) {
            logger.trace(this.diagnosticContext.makeTimeSeriesPoint("aimd_rtt", nowMs).addField("aimd_id", this.hashCode()).addField("rtt", rtt));
        }
        this.rtt = rtt;
    }

    public void update(RateControlInput input, long nowMs) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (!this.bitrateIsInitialized) {
            if (this.timeFirstIncomingEstimate < 0L) {
                if (input.incomingBitRate > 0L) {
                    this.timeFirstIncomingEstimate = nowMs;
                }
            } else {
                long timeSinceFirstIncomingEstimate = nowMs - this.timeFirstIncomingEstimate;
                if (timeSinceFirstIncomingEstimate > 10000L) {
                    this.timeFirstIncomingEstimate = input.incomingBitRate > 0L ? nowMs : -1L;
                    ++this.incomingBitrateExpirations;
                } else if (timeSinceFirstIncomingEstimate > 5000L && input.incomingBitRate > 0L) {
                    this.currentBitrateBps = input.incomingBitRate;
                    this.bitrateIsInitialized = true;
                }
            }
        }
        if (this.updated && this.currentInput.bwState == BandwidthUsage.kBwOverusing) {
            this.currentInput.noiseVar = input.noiseVar;
            this.currentInput.incomingBitRate = input.incomingBitRate;
        } else {
            this.updated = true;
            this.currentInput.copy(input);
        }
    }

    public long updateBandwidthEstimate(long nowMs) {
        this.currentBitrateBps = this.changeBitrate(this.currentBitrateBps, this.currentInput.incomingBitRate, nowMs);
        if (logger.isTraceEnabled() && this.isValidEstimate()) {
            logger.trace(this.diagnosticContext.makeTimeSeriesPoint("aimd_estimate", nowMs).addField("aimd_id", this.hashCode()).addField("estimate_bps", this.currentBitrateBps).addField("incoming_bps", this.currentInput.incomingBitRate));
        }
        if (nowMs - this.timeOfLastLog > 1000L) {
            this.timeOfLastLog = nowMs;
        }
        return this.currentBitrateBps;
    }

    private void updateMaxBitRateEstimate(float incomingBitrateKbps) {
        float alpha = 0.05f;
        this.avgMaxBitrateKbps = this.avgMaxBitrateKbps == -1.0f ? incomingBitrateKbps : (1.0f - alpha) * this.avgMaxBitrateKbps + alpha * incomingBitrateKbps;
        float norm = Math.max(this.avgMaxBitrateKbps, 1.0f);
        this.varMaxBitrateKbps = (1.0f - alpha) * this.varMaxBitrateKbps + alpha * (this.avgMaxBitrateKbps - incomingBitrateKbps) * (this.avgMaxBitrateKbps - incomingBitrateKbps) / norm;
        if (this.varMaxBitrateKbps < 0.4f) {
            this.varMaxBitrateKbps = 0.4f;
        }
        if (this.varMaxBitrateKbps > 2.5f) {
            this.varMaxBitrateKbps = 2.5f;
        }
    }
}

