/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;

@Immutable
public class GetKeyMultimapOperation<V>
extends AbstractMultimapKeyOperation<Collection<V>> {
    private int size;
    private Collection<V> result;

    public GetKeyMultimapOperation(ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, DataFormat dataFormat, ClientStatistics clientStatistics, boolean supportsDuplicates) {
        super((short)103, (short)104, channelFactory, key, keyBytes, cacheName, clientTopology, flags, cfg, dataFormat, clientStatistics, supportsDuplicates);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result = null;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(Collections.emptySet());
            return;
        }
        if (this.result == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = this.supportsDuplicates ? new ArrayList(this.size) : new HashSet(this.size);
            decoder.checkpoint();
        }
        while (this.result.size() < this.size) {
            Object value = MarshallerUtil.bytes2obj(this.channelFactory.getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat().isObjectStorage(), this.cfg.getClassAllowList());
            this.result.add(value);
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

