/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security;

import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class StringPermission
extends Permission {
    public static final String ACTIONS_SEPARATOR = ",";
    private final Set<String> actions;

    public StringPermission(String permissionName, String ... actions) {
        super(StringPermission.validateAndTrim(permissionName, "Permission name"));
        this.actions = actions != null && actions.length != 0 ? StringPermission.checkActions(actions) : Collections.emptySet();
    }

    private static Set<String> checkActions(String[] actions) {
        HashSet<String> validActions = new HashSet<String>(actions.length, 1.0f);
        for (String action : actions) {
            validActions.add(StringPermission.validateAndTrim(action, "Action"));
        }
        return Collections.unmodifiableSet(validActions);
    }

    private static String validateAndTrim(String str, String paramName) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("%s must not be null", paramName));
        }
        if ((str = str.trim()).isEmpty()) {
            throw new IllegalArgumentException(String.format("%s must not be empty", paramName));
        }
        if (str.contains(ACTIONS_SEPARATOR)) {
            throw new IllegalArgumentException(String.format("%s must not contain '%s'", paramName, ACTIONS_SEPARATOR));
        }
        return str;
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof StringPermission) || !this.getName().equals(p.getName())) {
            return false;
        }
        StringPermission that = (StringPermission)p;
        if (that.actions.isEmpty()) {
            return true;
        }
        if (this.actions.isEmpty()) {
            return false;
        }
        for (String action : that.actions) {
            if (!this.actions.contains(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object p) {
        if (this == p) {
            return true;
        }
        if (!(p instanceof StringPermission)) {
            return false;
        }
        StringPermission that = (StringPermission)p;
        return this.getName().equals(that.getName()) && this.actions.equals(that.actions);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.toString().toCharArray());
    }

    @Override
    public String getActions() {
        return this.actions.isEmpty() ? null : String.join((CharSequence)ACTIONS_SEPARATOR, this.actions);
    }
}

