/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.reader.AeshInputStream;
import org.jboss.aesh.util.LoggerUtil;

public class ConsoleInputSession {
    private final AeshInputStream aeshInputStream;
    private final ExecutorService executorService;
    private final BlockingQueue<int[]> blockingQueue = new LinkedBlockingQueue<int[]>(1000);
    private static final Logger LOGGER = LoggerUtil.getLogger(ConsoleInputSession.class.getName());
    private static final int[] NULL_INPUT = new int[]{-1};

    public ConsoleInputSession(InputStream consoleStream) {
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread inputThread = Executors.defaultThreadFactory().newThread(runnable);
                inputThread.setName("Aesh InputStream Reader");
                inputThread.setDaemon(true);
                return inputThread;
            }
        });
        this.aeshInputStream = new AeshInputStream(consoleStream);
        this.startReader();
    }

    private void startReader() {
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    while (ConsoleInputSession.this.aeshInputStream.isReading()) {
                        ConsoleInputSession.this.blockingQueue.put(ConsoleInputSession.this.aeshInputStream.readAll());
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Got runtime exception in reader: ", e);
                    ConsoleInputSession.this.stop();
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Got exception in reader: ", e);
                    ConsoleInputSession.this.stop();
                }
            }
        };
        this.executorService.execute(reader);
    }

    public int[] readAll() {
        try {
            return this.blockingQueue.take();
        }
        catch (InterruptedException e) {
            return NULL_INPUT;
        }
    }

    public boolean hasInput() {
        return this.blockingQueue.peek() != null;
    }

    public void stop() {
        if (!this.executorService.isShutdown()) {
            try {
                this.aeshInputStream.stop();
                this.aeshInputStream.close();
                this.executorService.shutdownNow();
                LOGGER.info("input stream is closed, readers finished...");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed when trying to close streams", e);
            }
        }
    }

    public void writeToInput(String data) {
        int[] input = new int[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            input[i] = data.charAt(i);
        }
        try {
            this.blockingQueue.put(input);
        }
        catch (InterruptedException e) {
            LOGGER.warning("Failed to add to input queue");
        }
    }
}

