/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.undertow.servlet.api.InstanceFactory;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FilterBuildItem
extends MultiBuildItem {
    private final String name;
    private final String filterClass;
    private final int loadOnStartup;
    private final boolean asyncSupported;
    private final List<FilterMappingInfo> mappings;
    private final InstanceFactory<? extends Filter> instanceFactory;
    private final Map<String, String> initParams;

    private FilterBuildItem(Builder builder) {
        this.name = builder.name;
        this.filterClass = builder.filterClass;
        this.loadOnStartup = builder.loadOnStartup;
        this.asyncSupported = builder.asyncSupported;
        this.mappings = List.copyOf(builder.mappings);
        this.instanceFactory = builder.instanceFactory;
        this.initParams = Collections.unmodifiableMap(new HashMap<String, String>(builder.initParams));
    }

    public String getName() {
        return this.name;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public List<FilterMappingInfo> getMappings() {
        return this.mappings;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public InstanceFactory<? extends Filter> getInstanceFactory() {
        return this.instanceFactory;
    }

    public static Builder builder(String name, String filterClass) {
        return new Builder(name, filterClass);
    }

    public static class Builder {
        private final String name;
        private final String filterClass;
        private int loadOnStartup;
        private boolean asyncSupported;
        private final List<FilterMappingInfo> mappings = new ArrayList<FilterMappingInfo>();
        private InstanceFactory<? extends Filter> instanceFactory;
        private final Map<String, String> initParams = new HashMap<String, String>();

        public Builder(String name, String filterClass) {
            this.name = name;
            this.filterClass = filterClass;
        }

        public String getName() {
            return this.name;
        }

        public String getFilterClass() {
            return this.filterClass;
        }

        public int getLoadOnStartup() {
            return this.loadOnStartup;
        }

        public Builder setLoadOnStartup(int loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
            return this;
        }

        public boolean isAsyncSupported() {
            return this.asyncSupported;
        }

        public Builder setAsyncSupported(boolean asyncSupported) {
            this.asyncSupported = asyncSupported;
            return this;
        }

        public List<FilterMappingInfo> getMappings() {
            return this.mappings;
        }

        public InstanceFactory<? extends Filter> getInstanceFactory() {
            return this.instanceFactory;
        }

        public Builder setInstanceFactory(InstanceFactory<? extends Filter> instanceFactory) {
            this.instanceFactory = instanceFactory;
            return this;
        }

        public Map<String, String> getInitParams() {
            return this.initParams;
        }

        public Builder addMapping(FilterMappingInfo mappingPath) {
            this.mappings.add(mappingPath);
            return this;
        }

        public Builder addFilterUrlMapping(String mapping, DispatcherType dispatcher) {
            this.mappings.add(new FilterMappingInfo(FilterMappingInfo.MappingType.URL, mapping, dispatcher));
            return this;
        }

        public Builder addFilterServletNameMapping(String mapping, DispatcherType dispatcher) {
            this.mappings.add(new FilterMappingInfo(FilterMappingInfo.MappingType.SERVLET, mapping, dispatcher));
            return this;
        }

        public Builder insertFilterUrlMapping(int pos, String mapping, DispatcherType dispatcher) {
            this.mappings.add(pos, new FilterMappingInfo(FilterMappingInfo.MappingType.URL, mapping, dispatcher));
            return this;
        }

        public Builder insertFilterServletNameMapping(int pos, String filterName, String mapping, DispatcherType dispatcher) {
            this.mappings.add(pos, new FilterMappingInfo(FilterMappingInfo.MappingType.SERVLET, mapping, dispatcher));
            return this;
        }

        public Builder addInitParam(String key, String value) {
            this.initParams.put(key, value);
            return this;
        }

        public FilterBuildItem build() {
            return new FilterBuildItem(this);
        }
    }

    public static class FilterMappingInfo {
        private MappingType mappingType;
        private String mapping;
        private DispatcherType dispatcher;

        public FilterMappingInfo(MappingType mappingType, String mapping, DispatcherType dispatcher) {
            this.mappingType = mappingType;
            this.mapping = mapping;
            this.dispatcher = dispatcher;
        }

        public void setMappingType(MappingType mappingType) {
            this.mappingType = mappingType;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public void setDispatcher(DispatcherType dispatcher) {
            this.dispatcher = dispatcher;
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        public String getMapping() {
            return this.mapping;
        }

        public DispatcherType getDispatcher() {
            return this.dispatcher;
        }

        public static enum MappingType {
            URL,
            SERVLET;

        }
    }
}

