/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.singleUseObject;

import java.util.Collections;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapSingleUseObjectProvider
implements SingleUseObjectProvider {
    private static final Logger LOG = Logger.getLogger(MapSingleUseObjectProvider.class);
    protected final MapStorage<MapSingleUseObjectEntity, SingleUseObjectValueModel> singleUseObjectTx;

    public MapSingleUseObjectProvider(MapStorage<MapSingleUseObjectEntity, SingleUseObjectValueModel> storage) {
        this.singleUseObjectTx = storage;
    }

    public void put(String key, long lifespanSeconds, Map<String, String> notes) {
        LOG.tracef("put(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            throw new ModelDuplicateException("Single-use object entity exists: " + singleUseEntity.getObjectKey());
        }
        singleUseEntity = DeepCloner.DUMB_CLONER.newInstance(MapSingleUseObjectEntity.class);
        singleUseEntity.setObjectKey(key);
        singleUseEntity.setExpiration(Time.currentTimeMillis() + TimeAdapter.fromSecondsToMilliseconds(lifespanSeconds));
        singleUseEntity.setNotes(notes);
        this.singleUseObjectTx.create(singleUseEntity);
    }

    public Map<String, String> get(String key) {
        LOG.tracef("get(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseObject = this.getWithExpiration(key);
        if (singleUseObject != null) {
            Map<String, String> notes = singleUseObject.getNotes();
            return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
        }
        return null;
    }

    public Map<String, String> remove(String key) {
        LOG.tracef("remove(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            Map<String, String> notes = singleUseEntity.getNotes();
            if (this.singleUseObjectTx.delete(singleUseEntity.getId())) {
                return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
            }
        }
        return null;
    }

    public boolean replace(String key, Map<String, String> notes) {
        LOG.tracef("replace(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            singleUseEntity.setNotes(notes);
            return true;
        }
        return false;
    }

    public boolean putIfAbsent(String key, long lifespanInSeconds) {
        LOG.tracef("putIfAbsent(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseEntity = this.getWithExpiration(key);
        if (singleUseEntity != null) {
            return false;
        }
        singleUseEntity = DeepCloner.DUMB_CLONER.newInstance(MapSingleUseObjectEntity.class);
        singleUseEntity.setObjectKey(key);
        singleUseEntity.setExpiration(Time.currentTimeMillis() + TimeAdapter.fromSecondsToMilliseconds(lifespanInSeconds));
        this.singleUseObjectTx.create(singleUseEntity);
        return true;
    }

    public boolean contains(String key) {
        LOG.tracef("contains(%s)%s", (Object)key, StackUtil.getShortStackTrace());
        MapSingleUseObjectEntity singleUseObject = this.getWithExpiration(key);
        return singleUseObject != null;
    }

    public void close() {
    }

    private MapSingleUseObjectEntity getWithExpiration(String key) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(SingleUseObjectValueModel.SearchableFields.OBJECT_KEY, ModelCriteriaBuilder.Operator.EQ, new Object[]{key});
        return this.singleUseObjectTx.read(QueryParameters.withCriteria(mcb)).filter(entity -> {
            if (ExpirationUtils.isExpired(entity, false)) {
                this.singleUseObjectTx.delete(entity.getId());
                return false;
            }
            return true;
        }).findFirst().orElse(null);
    }
}

