/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class CountChangeSetFilter
implements ChangeSetFilter {
    private int changeSetsToAllow;
    private int changeSetsSeen;

    public CountChangeSetFilter(int changeSetsToAllow) {
        this.changeSetsToAllow = changeSetsToAllow;
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        ++this.changeSetsSeen;
        if (this.changeSetsSeen <= this.changeSetsToAllow) {
            return new ChangeSetFilterResult(true, "One of " + this.changeSetsToAllow + " changesets to run", this.getClass());
        }
        return new ChangeSetFilterResult(false, "Only running " + this.changeSetsToAllow + " changesets", this.getClass());
    }
}

