/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.function.AggregateWindowEmulationQueryTransformer;
import org.hibernate.dialect.function.InverseDistributionFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingOrderedSetAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmOrderedSetAggregateFunction;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.spi.TypeConfiguration;

public class InverseDistributionWindowEmulation
extends InverseDistributionFunction {
    public InverseDistributionWindowEmulation(String name, FunctionParameterType parameterType, TypeConfiguration typeConfiguration) {
        super(name, parameterType, typeConfiguration);
    }

    @Override
    public <T> SelfRenderingSqmOrderedSetAggregateFunction<T> generateSqmOrderedSetAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return new InverseDistributionFunction.SelfRenderingInverseDistributionFunction<T>(arguments, filter, withinGroupClause, impliedResultType, queryEngine){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
                List<SortSpecification> withinGroup;
                Clause currentClause = walker.getCurrentClauseStack().getCurrent();
                if (currentClause == Clause.OVER) {
                    return super.convertToSqlAst(walker);
                }
                if (currentClause != Clause.SELECT) {
                    throw new IllegalArgumentException("Can't emulate [" + InverseDistributionWindowEmulation.this.getName() + "] in clause " + currentClause + ". Only the SELECT clause is supported");
                }
                ReturnableType<?> resultType = this.resolveResultType(walker.getCreationContext().getMappingMetamodel().getTypeConfiguration());
                List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
                ArgumentsValidator argumentsValidator = this.getArgumentsValidator();
                if (argumentsValidator != null) {
                    argumentsValidator.validateSqlTypes(arguments, this.getFunctionName());
                }
                if (this.getWithinGroup() == null) {
                    withinGroup = Collections.emptyList();
                } else {
                    walker.getCurrentClauseStack().push(Clause.ORDER);
                    try {
                        List<SqmSortSpecification> sortSpecifications = this.getWithinGroup().getSortSpecifications();
                        withinGroup = new ArrayList(sortSpecifications.size());
                        for (SqmSortSpecification sortSpecification : sortSpecifications) {
                            SortSpecification specification = (SortSpecification)walker.visitSortSpecification(sortSpecification);
                            if (specification == null) continue;
                            withinGroup.add(specification);
                        }
                    }
                    finally {
                        walker.getCurrentClauseStack().pop();
                    }
                }
                SelfRenderingOrderedSetAggregateFunctionSqlAstExpression function = new SelfRenderingOrderedSetAggregateFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, this.getFilter() == null ? null : (Predicate)this.getFilter().accept(walker), withinGroup, resultType, this.getMappingModelExpressible(walker, resultType, arguments));
                Over<Object> windowFunction = new Over<Object>(function, new ArrayList<Expression>(), Collections.emptyList());
                walker.registerQueryTransformer(new AggregateWindowEmulationQueryTransformer(windowFunction, withinGroup, null));
                return windowFunction;
            }
        };
    }
}

