/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.Collections;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.query.sqm.CastType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public interface JdbcMapping
extends MappingType,
JdbcMappingContainer {
    public JavaType getJavaTypeDescriptor();

    public JdbcType getJdbcType();

    public ValueExtractor<?> getJdbcValueExtractor();

    public ValueBinder getJdbcValueBinder();

    default public CastType getCastType() {
        return this.getJdbcType().getCastType();
    }

    @Incubating
    default public JdbcLiteralFormatter getJdbcLiteralFormatter() {
        return this.getJdbcType().getJdbcLiteralFormatter(this.getMappedJavaType());
    }

    @Override
    default public JavaType<?> getMappedJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Incubating
    default public JavaType<?> getJdbcJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Incubating
    default public BasicValueConverter getValueConverter() {
        return null;
    }

    default public Object convertToRelationalValue(Object value) {
        BasicValueConverter valueConverter = this.getValueConverter();
        return valueConverter == null ? value : valueConverter.toRelationalValue(value);
    }

    default public Object convertToDomainValue(Object value) {
        BasicValueConverter valueConverter = this.getValueConverter();
        return valueConverter == null ? value : valueConverter.toDomainValue(value);
    }

    @Override
    default public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    @Deprecated(forRemoval=true)
    default public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this);
    }

    @Override
    default public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this;
    }

    @Override
    default public JdbcMapping getSingleJdbcMapping() {
        return this;
    }

    @Override
    default public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this);
        return 1;
    }

    @Override
    default public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this);
        return 1;
    }
}

