/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.metamodel.Bindable;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.internal.AnyMappingSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassSqmPathSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmMappingModelHelper {
    private SqmMappingModelHelper() {
    }

    public static EntityPersister resolveEntityPersister(EntityDomainType<?> entityType, SessionFactoryImplementor sessionFactory) {
        String hibernateEntityName = entityType.getHibernateEntityName();
        return sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(hibernateEntityName);
    }

    public static <J> SqmPathSource<J> resolveSqmKeyPathSource(DomainType<J> valueDomainType, Bindable.BindableType jpaBindableType, boolean isGeneric) {
        return SqmMappingModelHelper.resolveSqmPathSource(CollectionPart.Nature.INDEX.getName(), valueDomainType, jpaBindableType, isGeneric);
    }

    public static <J> SqmPathSource<J> resolveSqmPathSource(String name, DomainType<J> valueDomainType, Bindable.BindableType jpaBindableType, boolean isGeneric) {
        return SqmMappingModelHelper.resolveSqmPathSource(name, null, valueDomainType, valueDomainType.getExpressibleJavaType(), jpaBindableType, isGeneric);
    }

    public static <J> SqmPathSource<J> resolveSqmPathSource(String name, SqmPathSource<J> pathModel, DomainType<J> valueDomainType, JavaType<?> relationalJavaType, Bindable.BindableType jpaBindableType, boolean isGeneric) {
        if (valueDomainType instanceof BasicDomainType) {
            return new BasicSqmPathSource<J>(name, pathModel, (BasicDomainType)valueDomainType, relationalJavaType, jpaBindableType, isGeneric);
        }
        if (valueDomainType instanceof AnyMappingDomainType) {
            return new AnyMappingSqmPathSource<J>(name, pathModel, (AnyMappingDomainType)valueDomainType, jpaBindableType);
        }
        if (valueDomainType instanceof EmbeddableDomainType) {
            return new EmbeddedSqmPathSource<J>(name, pathModel, (EmbeddableDomainType)valueDomainType, jpaBindableType, isGeneric);
        }
        if (valueDomainType instanceof EntityDomainType) {
            return new EntitySqmPathSource<J>(name, pathModel, (EntityDomainType)valueDomainType, jpaBindableType, isGeneric);
        }
        if (valueDomainType instanceof MappedSuperclassDomainType) {
            return new MappedSuperclassSqmPathSource<J>(name, pathModel, (MappedSuperclassDomainType)valueDomainType, jpaBindableType);
        }
        throw new IllegalArgumentException("Unrecognized value type Java-type [" + valueDomainType.getTypeName() + "] for plural attribute value");
    }

    public static MappingModelExpressible<?> resolveMappingModelExpressible(SqmTypedNode<?> sqmNode, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator) {
        if (sqmNode instanceof SqmPath) {
            return SqmMappingModelHelper.resolveSqmPath((SqmPath)sqmNode, domainModel, tableGroupLocator);
        }
        SqmExpressible<?> nodeType = sqmNode.getNodeType();
        if (nodeType instanceof BasicType) {
            return (BasicType)nodeType;
        }
        return null;
    }

    private static ModelPart resolveSqmPath(SqmPath<?> sqmPath, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator) {
        if (sqmPath instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)sqmPath;
            EntityDomainType treatTargetType = treatedPath.getTreatTarget();
            return domainModel.findEntityDescriptor(treatTargetType.getHibernateEntityName());
        }
        if (sqmPath.getLhs() instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)sqmPath.getLhs();
            EntityDomainType treatTargetType = treatedPath.getTreatTarget();
            EntityPersister container = domainModel.findEntityDescriptor(treatTargetType.getHibernateEntityName());
            return container.findSubPart(sqmPath.getNavigablePath().getLocalName(), container);
        }
        if (sqmPath instanceof AbstractSqmSpecificPluralPartPath) {
            TableGroup lhsTableGroup = tableGroupLocator.apply(sqmPath.getLhs().getLhs().getNavigablePath());
            ModelPartContainer pluralPart = (ModelPartContainer)lhsTableGroup.getModelPart().findSubPart(sqmPath.getLhs().getReferencedPathSource().getPathName(), null);
            CollectionPart collectionPart = (CollectionPart)pluralPart.findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
            if (collectionPart instanceof EntityCollectionPart) {
                return ((EntityCollectionPart)collectionPart).getAssociatedEntityMappingType();
            }
            return collectionPart;
        }
        if (sqmPath.getLhs() == null) {
            EntityDomainType entityDomainType = (EntityDomainType)sqmPath.getReferencedPathSource();
            return domainModel.findEntityDescriptor(entityDomainType.getHibernateEntityName());
        }
        TableGroup lhsTableGroup = tableGroupLocator.apply(sqmPath.getLhs().getNavigablePath());
        ModelPartContainer modelPart = lhsTableGroup == null ? (ModelPartContainer)SqmMappingModelHelper.resolveSqmPath(sqmPath.getLhs(), domainModel, tableGroupLocator) : lhsTableGroup.getModelPart();
        return modelPart.findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
    }

    public static EntityMappingType resolveExplicitTreatTarget(SqmPath<?> sqmPath, SqmToSqlAstConverter converter) {
        JpaPath parentPath = sqmPath.getLhs();
        if (parentPath instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)parentPath;
            return SqmMappingModelHelper.resolveEntityPersister(treatedPath.getTreatTarget(), converter.getCreationContext().getSessionFactory());
        }
        return null;
    }
}

