/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.operation;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.callback.CallbackReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.operation.OperationConstant;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.io.requestbody.RequestBodyReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementReader;
import io.smallrye.openapi.runtime.io.server.ServerReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import org.eclipse.microprofile.openapi.models.Operation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.MethodInfo;

public class OperationReader {
    private OperationReader() {
    }

    public static Operation readOperation(AnnotationScannerContext context, AnnotationInstance annotationInstance, MethodInfo methodInfo) {
        if (annotationInstance != null) {
            IoLogging.logger.singleAnnotation("@Operation");
            OperationImpl operation = new OperationImpl();
            operation.setSummary((String)Annotations.value(annotationInstance, "summary"));
            operation.setDescription((String)Annotations.value(annotationInstance, "description"));
            operation.setExternalDocs(ExternalDocsReader.readExternalDocs(context, annotationInstance.value("externalDocs")));
            operation.setParameters(ParameterReader.readParametersList(context, annotationInstance.value("parameters")).orElse(null));
            operation.setRequestBody(RequestBodyReader.readRequestBody(context, annotationInstance.value("requestBody")));
            operation.setResponses(ResponseReader.readResponses(context, annotationInstance.value("responses")));
            operation.setSecurity(SecurityRequirementReader.readSecurityRequirements(annotationInstance.value("security"), annotationInstance.value("securitySets")).orElse(null));
            operation.setExtensions(ExtensionReader.readExtensions(context, annotationInstance.value("extensions")));
            operation.setOperationId((String)Annotations.value(annotationInstance, "operationId"));
            operation.setDeprecated((Boolean)Annotations.value(annotationInstance, "deprecated"));
            return operation;
        }
        return null;
    }

    public static Operation readOperation(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonObject("Operation");
        OperationImpl model = new OperationImpl();
        model.setTags(JsonUtil.readStringArray(node.get("tags")).orElse(null));
        model.setSummary(JsonUtil.stringProperty(node, "summary"));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setExternalDocs(ExternalDocsReader.readExternalDocs(node.get("externalDocs")));
        model.setOperationId(JsonUtil.stringProperty(node, "operationId"));
        model.setParameters(ParameterReader.readParameterList(node.get("parameters")).orElse(null));
        model.setRequestBody(RequestBodyReader.readRequestBody(node.get("requestBody")));
        model.setResponses(ResponseReader.readResponses(node.get("responses")));
        model.setCallbacks(CallbackReader.readCallbacks(node.get("callbacks")));
        model.setDeprecated(JsonUtil.booleanProperty(node, "deprecated").orElse(null));
        model.setSecurity(SecurityRequirementReader.readSecurityRequirements(node.get("security")).orElse(null));
        model.setServers(ServerReader.readServers(node.get("servers")).orElse(null));
        ExtensionReader.readExtensions(node, model);
        return model;
    }

    public static boolean operationIsHidden(MethodInfo method) {
        AnnotationInstance operationAnnotation = method.annotation(OperationConstant.DOTNAME_OPERATION);
        if (operationAnnotation != null) {
            return operationAnnotation.value("hidden") != null && operationAnnotation.value("hidden").asBoolean();
        }
        return false;
    }

    public static AnnotationInstance getOperationAnnotation(MethodInfo method) {
        return method.annotation(OperationConstant.DOTNAME_OPERATION);
    }
}

