/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.SecurityNameMapping;
import org.snmp4j.transport.tls.TLSTMUtil;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class DefaultTlsTmSecurityCallback
implements TlsTmSecurityCallback<X509Certificate> {
    private LogAdapter LOGGER = LogFactory.getLogger(DefaultTlsTmSecurityCallback.class);
    private Map<SecurityNameMapping, OctetString> securityNameMapping = new HashMap<SecurityNameMapping, OctetString>();
    private Map<Address, String> localCertMapping = new HashMap<Address, String>();
    private Set<String> acceptedSubjectDN = new HashSet<String>();
    private Set<String> acceptedIssuerDN = new HashSet<String>();

    public OctetString getSecurityName(X509Certificate[] peerCertificateChain) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Serializable)((Object)("Getting security name for peer certificate chain: " + Arrays.asList(peerCertificateChain))));
        }
        OctetString fallbackSecurityName = null;
        for (Map.Entry<SecurityNameMapping, OctetString> entry : this.securityNameMapping.entrySet()) {
            OctetString fingerprint = entry.getKey().getFingerprint();
            for (X509Certificate cert : peerCertificateChain) {
                OctetString certFingerprint = null;
                certFingerprint = TLSTMUtil.getFingerprint(cert);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Serializable)((Object)("Matching peer cert fingerprint " + certFingerprint + " against local " + fingerprint)));
                }
                if (fingerprint.length() != 0 && (certFingerprint == null || !certFingerprint.equals(fingerprint))) continue;
                SecurityNameMapping.CertMappingType mappingType = entry.getKey().getType();
                OctetString data = entry.getKey().getData();
                OctetString tmSecurityName = null;
                try {
                    tmSecurityName = this.mapCertToTSN(cert, mappingType, data);
                    if (fallbackSecurityName == null && tmSecurityName == null) {
                        fallbackSecurityName = entry.getKey().getSecurityName();
                    }
                }
                catch (CertificateParsingException e) {
                    this.LOGGER.warn((Serializable)((Object)("Failed to parse client certificate: " + e.getMessage())));
                }
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Serializable)((Object)("Matched security name: " + tmSecurityName)));
                }
                if (tmSecurityName == null || tmSecurityName.length() > 32) continue;
                return tmSecurityName;
            }
        }
        if (fallbackSecurityName != null) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Serializable)((Object)("Matched security name '" + fallbackSecurityName + "' by fallback mapping")));
            }
            return fallbackSecurityName;
        }
        return null;
    }

    private OctetString mapCertToTSN(X509Certificate cert, SecurityNameMapping.CertMappingType mappingType, OctetString data) throws CertificateParsingException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Serializable)((Object)("Mapping cert to security name " + cert + " with type " + (Object)((Object)mappingType) + " and date " + data)));
        }
        switch (mappingType) {
            case Specified: {
                return data;
            }
            case SANAny: 
            case SANRFC822Name: {
                Object entry = TLSTMUtil.getSubjAltName(cert.getSubjectAlternativeNames(), 1);
                if (entry != null) {
                    String[] rfc822Name = ((String)entry).split("@");
                    return new OctetString(rfc822Name[0] + "@" + rfc822Name[1].toLowerCase());
                }
            }
            case SANDNSName: {
                Object entry = TLSTMUtil.getSubjAltName(cert.getSubjectAlternativeNames(), 2);
                if (entry != null) {
                    String dNSName = ((String)entry).toLowerCase();
                    return new OctetString(dNSName);
                }
            }
            case SANIpAddress: {
                OctetString address = TLSTMUtil.getIpAddressFromSubjAltName(cert.getSubjectAlternativeNames());
                if (address != null) {
                    return address;
                }
            }
            case CommonName: {
                X500Principal x500Principal = cert.getSubjectX500Principal();
                return new OctetString(x500Principal.getName());
            }
        }
        return null;
    }

    @Override
    public boolean isClientCertificateAccepted(X509Certificate peerEndCertificate) throws CertificateException {
        if (this.acceptedSubjectDN.isEmpty()) {
            return false;
        }
        if (peerEndCertificate == null || !this.acceptedSubjectDN.contains(peerEndCertificate.getSubjectDN().getName())) {
            throw new CertificateException("Client certificate " + peerEndCertificate + " has no accepted subject DN: " + this.acceptedSubjectDN);
        }
        return true;
    }

    public boolean isServerCertificateAccepted(X509Certificate[] peerCertificateChain) throws CertificateException {
        if (peerCertificateChain == null || peerCertificateChain.length == 0) {
            throw new CertificateException("Server certificate chain is empty");
        }
        int accepted = -1;
        block0: for (Map.Entry<SecurityNameMapping, OctetString> entry : this.securityNameMapping.entrySet()) {
            OctetString fingerprint = entry.getKey().getFingerprint();
            for (X509Certificate cert : peerCertificateChain) {
                OctetString certFingerprint = null;
                certFingerprint = TLSTMUtil.getFingerprint(cert);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Serializable)((Object)("Matching server fingerprint " + certFingerprint + " against accepted " + fingerprint)));
                }
                if (fingerprint.length() == 0 || certFingerprint != null && certFingerprint.equals(fingerprint)) {
                    accepted = 1;
                    continue block0;
                }
                accepted = 0;
            }
        }
        if (accepted == 0) {
            throw new CertificateException("Server certificate chain " + Arrays.asList(peerCertificateChain) + " does not match accepted fingerprints: " + this.securityNameMapping);
        }
        String subject = peerCertificateChain[0].getSubjectDN().getName();
        if (this.acceptedSubjectDN.contains(subject)) {
            return true;
        }
        for (X509Certificate cert : peerCertificateChain) {
            Principal issuerDN = cert.getIssuerDN();
            if (issuerDN == null || !this.acceptedIssuerDN.contains(issuerDN.getName())) continue;
            return true;
        }
        if (this.acceptedSubjectDN.isEmpty() && this.acceptedIssuerDN.isEmpty()) {
            return false;
        }
        throw new CertificateException("Server certificate chain " + Arrays.asList(peerCertificateChain) + " rejected because issuer and subject DN not accepted");
    }

    @Override
    public boolean isAcceptedIssuer(X509Certificate issuerCertificate) throws CertificateException {
        Principal issuerDN = issuerCertificate.getIssuerDN();
        if (this.acceptedIssuerDN.isEmpty()) {
            return false;
        }
        if (issuerDN != null && this.acceptedIssuerDN.contains(issuerDN.getName())) {
            return true;
        }
        throw new CertificateException("Issuer certificate " + issuerCertificate + " does not have accepted DN: " + this.acceptedIssuerDN);
    }

    @Override
    public String getLocalCertificateAlias(Address targetAddress) {
        String localCert = this.localCertMapping.get(targetAddress);
        if (localCert == null) {
            return this.localCertMapping.get(null);
        }
        return localCert;
    }

    public void addSecurityNameMapping(OctetString fingerprint, SecurityNameMapping.CertMappingType type, OctetString data, OctetString securityName) {
        this.securityNameMapping.put(new SecurityNameMapping(fingerprint, data, type, securityName), securityName);
    }

    public OctetString removeSecurityNameMapping(OctetString fingerprint, SecurityNameMapping.CertMappingType type, OctetString data) {
        return this.securityNameMapping.remove(new SecurityNameMapping(fingerprint, data, type, null));
    }

    public void addAcceptedIssuerDN(String issuerDN) {
        this.acceptedIssuerDN.add(issuerDN);
    }

    public boolean removeAcceptedIssuerDN(String issuerDN) {
        return this.acceptedIssuerDN.remove(issuerDN);
    }

    public void addAcceptedSubjectDN(String subjectDN) {
        this.acceptedSubjectDN.add(subjectDN);
    }

    public boolean removeAcceptedSubjectDN(String subjectDN) {
        return this.acceptedSubjectDN.remove(subjectDN);
    }

    public void addLocalCertMapping(Address address, String certAlias) {
        this.localCertMapping.put(address, certAlias);
    }

    public String removeLocalCertMapping(Address address) {
        return this.localCertMapping.remove(address);
    }
}

