/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.AckedBatch;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.execution.MemoryReadBatch;
import org.logstash.execution.QueueBatch;
import org.logstash.ext.JrubyEventExtLibrary;

public final class AckedReadBatch
implements QueueBatch {
    private AckedBatch ackedBatch;
    private Collection<JrubyEventExtLibrary.RubyEvent> events;

    public static AckedReadBatch create(JRubyAckedQueueExt queue, int size, long timeout) {
        try {
            AckedBatch batch = queue.readBatch(size, timeout);
            return batch == null ? new AckedReadBatch() : new AckedReadBatch(batch);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static AckedReadBatch create() {
        return new AckedReadBatch();
    }

    private AckedReadBatch() {
        this.ackedBatch = null;
        this.events = new ArrayList<JrubyEventExtLibrary.RubyEvent>();
    }

    private AckedReadBatch(AckedBatch batch) {
        this.ackedBatch = batch;
        this.events = batch.events();
    }

    @Override
    public RubyArray<JrubyEventExtLibrary.RubyEvent> to_a() {
        RubyArray result = RubyUtil.RUBY.newArray(this.events.size());
        for (JrubyEventExtLibrary.RubyEvent e : this.events) {
            if (MemoryReadBatch.isCancelled(e)) continue;
            result.append((IRubyObject)e);
        }
        return result;
    }

    @Override
    public Collection<JrubyEventExtLibrary.RubyEvent> events() {
        return this.events;
    }

    @Override
    public void close() throws IOException {
        if (this.ackedBatch != null) {
            this.ackedBatch.close();
        }
    }

    @Override
    public int filteredSize() {
        return this.events.size();
    }
}

