/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.LogDirFailureChannel;
import kafka.server.PartitionMetadata;
import kafka.server.PartitionMetadataFile$;
import kafka.server.PartitionMetadataFile$PartitionMetadataFileFormatter$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!B\u0015+\u0011\u0003yc!B\u0019+\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%I\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0019\u000b!\u0019!C\u0005\u000f\"1\u0001+\u0001Q\u0001\n!Cq!U\u0001C\u0002\u0013%!\u000b\u0003\u0004W\u0003\u0001\u0006Ia\u0015\u0005\u0006/\u0006!\t\u0001W\u0004\u0006C\u0006A\tA\u0019\u0004\u0006I\u0006A\t!\u001a\u0005\u0006s-!\tA\u001a\u0005\u0006O.!\t\u0001\u001b\u0004\u0005q\u0006\u0001\u0011\u0010C\u0005\u0002\u00049\u0011\t\u0011)A\u0005S\"Q\u0011Q\u0001\b\u0003\u0002\u0003\u0006I!a\u0002\t\rerA\u0011AA\u0007\u0011\u001d\tYC\u0004C\u0001\u0003[1Q!\r\u0016\u0001\u0003_A!\"!\r\u0014\u0005\u000b\u0007I\u0011AA\u001a\u0011%\t)d\u0005B\u0001B\u0003%\u0011\f\u0003\u0006\u00028M\u0011\t\u0011)A\u0005\u0003sAa!O\n\u0005\u0002\u0005}\u0002\"CA$'\t\u0007I\u0011BA%\u0011!\tIf\u0005Q\u0001\n\u0005-\u0003\"CA.'\t\u0007I\u0011BA%\u0011!\tif\u0005Q\u0001\n\u0005-\u0003\"CA0'\t\u0007I\u0011BA1\u0011!\tIg\u0005Q\u0001\n\u0005\r\u0004\u0002CA6'\t\u0007I\u0011\u0002\u001f\t\u000f\u000554\u0003)A\u0005{!I\u0011qN\nA\u0002\u0013%\u0011\u0011\u000f\u0005\n\u0003\u001f\u001b\u0002\u0019!C\u0005\u0003#C\u0001\"!(\u0014A\u0003&\u00111\u000f\u0005\b\u0003O\u001bB\u0011AAU\u0011\u001d\tyk\u0005C\u0001\u0003cCq!a\u000b\u0014\t\u0003\ti\u0003C\u0004\u00024N!\t!!.\t\u000f\u0005u6\u0003\"\u0001\u00022\"9\u0011qX\n\u0005B\u0005\u0005\u0017!\u0006)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001'A\u0007\u0002U\t)\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1GS2,7CA\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aL\u0001\u001a!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f]\u0006lW-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012aa\u0015;sS:<\u0017A\u0007)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a8b[\u0016\u0004\u0013AE,iSR,7\u000b]1dKN\u0004\u0016\r\u001e;fe:,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000bQA]3hKbT!!T!\u0002\tU$\u0018\u000e\\\u0005\u0003\u001f*\u0013q\u0001U1ui\u0016\u0014h.A\nXQ&$Xm\u00159bG\u0016\u001c\b+\u0019;uKJt\u0007%\u0001\bDkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003M\u0003\"\u0001\u000e+\n\u0005U+$aA%oi\u0006y1)\u001e:sK:$h+\u001a:tS>t\u0007%A\u0004oK^4\u0015\u000e\\3\u0015\u0005e{\u0006C\u0001.^\u001b\u0005Y&B\u0001/B\u0003\tIw.\u0003\u0002_7\n!a)\u001b7f\u0011\u0015\u0001\u0017\u00021\u0001Z\u0003\r!\u0017N]\u0001\u001f!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f\r>\u0014X.\u0019;uKJ\u0004\"aY\u0006\u000e\u0003\u0005\u0011a\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWMR8s[\u0006$H/\u001a:\u0014\u0005-\u0019D#\u00012\u0002\rQ|g)\u001b7f)\tI7\u000f\u0005\u0002kc:\u00111n\u001c\t\u0003YVj\u0011!\u001c\u0006\u0003]:\na\u0001\u0010:p_Rt\u0014B\u000196\u0003\u0019\u0001&/\u001a3fM&\u0011AI\u001d\u0006\u0003aVBQ\u0001^\u0007A\u0002U\fA\u0001Z1uCB\u0011\u0001G^\u0005\u0003o*\u0012\u0011\u0003U1si&$\u0018n\u001c8NKR\fG-\u0019;b\u0005m\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019*fC\u0012\u0014UO\u001a4feV\u0019!0!\u0006\u0014\u00079\u00194\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fY\u0005)Q\u000f^5mg&\u0019\u0011\u0011A?\u0003\u000f1{wmZ5oO\u0006AAn\\2bi&|g.\u0001\u0004sK\u0006$WM\u001d\t\u00045\u0006%\u0011bAA\u00067\nq!)\u001e4gKJ,GMU3bI\u0016\u0014HCBA\b\u0003O\tI\u0003\u0005\u0003d\u001d\u0005E\u0001\u0003BA\n\u0003+a\u0001\u0001B\u0004\u0002\u00189\u0011\r!!\u0007\u0003\u0003Q\u000bB!a\u0007\u0002\"A\u0019A'!\b\n\u0007\u0005}QGA\u0004O_RD\u0017N\\4\u0011\u0007Q\n\u0019#C\u0002\u0002&U\u00121!\u00118z\u0011\u0019\t\u0019!\u0005a\u0001S\"9\u0011QA\tA\u0002\u0005\u001d\u0011\u0001\u0002:fC\u0012$\u0012!^\n\u0004'MZ\u0018\u0001\u00024jY\u0016,\u0012!W\u0001\u0006M&dW\rI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\u0007A\nY$C\u0002\u0002>)\u0012A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dGCBA!\u0003\u0007\n)\u0005\u0005\u00021'!1\u0011\u0011G\fA\u0002eCq!a\u000e\u0018\u0001\u0004\tI$\u0001\u0003qCRDWCAA&!\u0011\ti%!\u0016\u000e\u0005\u0005=#\u0002BA\u0019\u0003#R1!a\u0015B\u0003\rq\u0017n\\\u0005\u0005\u0003/\nyE\u0001\u0003QCRD\u0017!\u00029bi\"\u0004\u0013\u0001\u0003;f[B\u0004\u0016\r\u001e5\u0002\u0013Q,W\u000e\u001d)bi\"\u0004\u0013\u0001\u00027pG.,\"!a\u0019\u0011\u0007y\n)'C\u0002\u0002h}\u0012aa\u00142kK\u000e$\u0018!\u00027pG.\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001f\u0011L'\u000f^=U_BL7-\u00133PaR,\"!a\u001d\u0011\u000bQ\n)(!\u001f\n\u0007\u0005]TG\u0001\u0004PaRLwN\u001c\t\u0005\u0003w\nY)\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0019\u0019w.\\7p]*\u0019Q&a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0007CB\f7\r[3\u000b\u0005\u0005%\u0015aA8sO&!\u0011QRA?\u0005\u0011)V/\u001b3\u0002'\u0011L'\u000f^=U_BL7-\u00133PaR|F%Z9\u0015\t\u0005M\u0015\u0011\u0014\t\u0004i\u0005U\u0015bAALk\t!QK\\5u\u0011%\tY*IA\u0001\u0002\u0004\t\u0019(A\u0002yIE\n\u0001\u0003Z5sif$v\u000e]5d\u0013\u0012|\u0005\u000f\u001e\u0011)\u0007\t\n\t\u000bE\u00025\u0003GK1!!*6\u0005!1x\u000e\\1uS2,\u0017A\u0002:fG>\u0014H\r\u0006\u0003\u0002\u0014\u0006-\u0006bBAWG\u0001\u0007\u0011\u0011P\u0001\bi>\u0004\u0018nY%e\u0003)i\u0017-\u001f2f\r2,8\u000f\u001b\u000b\u0003\u0003'\u000ba!\u001a=jgR\u001cHCAA\\!\r!\u0014\u0011X\u0005\u0004\u0003w+$a\u0002\"p_2,\u0017M\\\u0001\u0007I\u0016dW\r^3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001b")
public class PartitionMetadataFile
implements Logging {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String logDir;
    private volatile Option<Uuid> dirtyTopicIdOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static File newFile(File file) {
        return PartitionMetadataFile$.MODULE$.newFile(file);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    private String logDir() {
        return this.logDir;
    }

    private Option<Uuid> dirtyTopicIdOpt() {
        return this.dirtyTopicIdOpt;
    }

    private void dirtyTopicIdOpt_$eq(Option<Uuid> x$1) {
        this.dirtyTopicIdOpt = x$1;
    }

    public void record(Uuid topicId) {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable & scala.Serializable)dirtyTopicId -> {
            PartitionMetadataFile.$anonfun$record$1(topicId, dirtyTopicId);
            return BoxedUnit.UNIT;
        });
        this.dirtyTopicIdOpt_$eq((Option<Uuid>)new Some((Object)topicId));
    }

    public void maybeFlush() {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionMetadataFile.$anonfun$maybeFlush$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public PartitionMetadata read() {
        Object object = this.lock();
        synchronized (object) {
            PartitionMetadata partitionMetadata = this.liftedTree1$1();
            return partitionMetadata;
        }
    }

    public boolean exists() {
        return this.file().exists();
    }

    public void delete() {
        Files.delete(this.file().toPath());
    }

    public String toString() {
        return new StringBuilder(28).append("PartitionMetadataFile(path=").append(this.path()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$record$1(Uuid topicId$1, Uuid dirtyTopicId) {
        Uuid uuid = dirtyTopicId;
        if (uuid == null ? topicId$1 != null : !uuid.equals(topicId$1)) {
            throw new InconsistentTopicIdException(new StringBuilder(59).append("Tried to record topic ID ").append(topicId$1).append(" to file ").append("but had already recorded ").append(dirtyTopicId).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$2(PartitionMetadataFile $this, Uuid topicId) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream($this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(PartitionMetadataFile$PartitionMetadataFileFormatter$.MODULE$.toFile(new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), topicId)));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)$this.tempPath(), (Path)$this.path());
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to partition metadata file ").append($this.file().getAbsolutePath()).toString();
            $this.logDirFailureChannel.maybeAddOfflineLogDir($this.logDir(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
        $this.dirtyTopicIdOpt_$eq((Option<Uuid>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(PartitionMetadataFile $this, Uuid x$1) {
        Object object = $this.lock();
        synchronized (object) {
            $this.dirtyTopicIdOpt().foreach((Function1 & Serializable & scala.Serializable)topicId -> {
                PartitionMetadataFile.$anonfun$maybeFlush$2($this, topicId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final /* synthetic */ PartitionMetadata liftedTree1$1() {
        try {
            PartitionMetadata partitionMetadata;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                partitionMetadata = new PartitionMetadataReadBuffer(this.file().getAbsolutePath(), reader).read();
            }
            return partitionMetadata;
        }
        catch (IOException e) {
            String msg = new StringBuilder(44).append("Error while reading partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        this.logDir = file.getParentFile().getParent();
        this.dirtyTopicIdOpt = None$.MODULE$;
    }

    public static class PartitionMetadataReadBuffer<T>
    implements Logging {
        private final String location;
        private final BufferedReader reader;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PartitionMetadata read() {
            String line = null;
            try {
                line = this.reader.readLine();
                String[] stringArray = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty()) throw this.malformedLineException$1(line);
                if (option.get() == null) throw this.malformedLineException$1(line);
                if (((SeqLike)option.get()).lengthCompare(2) != 0) throw this.malformedLineException$1(line);
                String version = (String)((SeqLike)option.get()).apply(1);
                if (new StringOps(Predef$.MODULE$.augmentString(version)).toInt() != PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()) throw new IOException(new StringBuilder(52).append("Unrecognized version of partition metadata file (").append(this.location).append("): ").append(version).toString());
                line = this.reader.readLine();
                String[] stringArray2 = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray2);
                if (option2.isEmpty()) throw this.malformedLineException$1(line);
                if (option2.get() == null) throw this.malformedLineException$1(line);
                if (((SeqLike)option2.get()).lengthCompare(2) != 0) throw this.malformedLineException$1(line);
                Uuid metadataTopicId = Uuid.fromString((String)((String)((SeqLike)option2.get()).apply(1)));
                if (!metadataTopicId.equals((Object)Uuid.ZERO_UUID)) return new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), metadataTopicId);
                throw new IOException(new StringBuilder(46).append("Invalid topic ID in partition metadata file (").append(this.location).append(")").toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1(line);
            }
        }

        private final IOException malformedLineException$1(String line) {
            return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
        }

        public PartitionMetadataReadBuffer(String location, BufferedReader reader) {
            this.location = location;
            this.reader = reader;
            Logging.$init$(this);
        }
    }
}

