/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(165ul, 133ul, 193ul, 76ul)
 * (0ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(80ul, 15ul, 51ul, 0ul)
 * (3ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(168ul, 136ul, 196ul, 79ul)
 * (3ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(83ul, 18ul, 54ul, 3ul)
 * (1192ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(1357ul, 1325ul, 1385ul, 1268ul)
 * (1192ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(1272ul, 1207ul, 1243ul, 1192ul)
 * (1048576ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(1048741ul, 1048709ul, 1048769ul, 1048652ul)
 * (1048576ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(1048656ul, 1048591ul, 1048627ul, 1048576ul)
 * (4251475ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(4251640ul, 4251608ul, 4251668ul, 4251551ul)
 * (4251475ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(4251555ul, 4251490ul, 4251526ul, 4251475ul)
 * (29852643761ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(29852643926ul, 29852643894ul, 29852643954ul, 29852643837ul)
 * (29852643761ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(29852643841ul, 29852643776ul, 29852643812ul, 29852643761ul)
 * (4398046511104ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(4398046511269ul, 4398046511237ul, 4398046511297ul, 4398046511180ul)
 * (4398046511104ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(4398046511184ul, 4398046511119ul, 4398046511155ul, 4398046511104ul)
 * (3948976685146ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(3948976685311ul, 3948976685279ul, 3948976685339ul, 3948976685222ul)
 * (3948976685146ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(3948976685226ul, 3948976685161ul, 3948976685197ul, 3948976685146ul)
 * (135763469567146206ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(135763469567146371ul, 135763469567146339ul, 135763469567146399ul, 135763469567146282ul)
 * (135763469567146206ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(135763469567146286ul, 135763469567146221ul, 135763469567146257ul, 135763469567146206ul)
 * (11654173250180970009ul + u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(11654173250180970174ul, 11654173250180970142ul, 11654173250180970202ul, 11654173250180970085ul)
 * (11654173250180970009ul + u64vec4(80ul, 15ul, 51ul, 0ul)) => u64vec4(11654173250180970089ul, 11654173250180970024ul, 11654173250180970060ul, 11654173250180970009ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(165ul, 133ul, 193ul, 76ul))) ? 1 : -1] array0;
  float[all(equal((0ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(80ul, 15ul, 51ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((3ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(168ul, 136ul, 196ul, 79ul))) ? 1 : -1] array2;
  float[all(equal((3ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(83ul, 18ul, 54ul, 3ul))) ? 1 : -1] array3;
  float[all(equal((1192ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(1357ul, 1325ul, 1385ul, 1268ul))) ? 1 : -1] array4;
  float[all(equal((1192ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(1272ul, 1207ul, 1243ul, 1192ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(1048741ul, 1048709ul, 1048769ul, 1048652ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(1048656ul, 1048591ul, 1048627ul, 1048576ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(4251640ul, 4251608ul, 4251668ul, 4251551ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(4251555ul, 4251490ul, 4251526ul, 4251475ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(29852643926ul, 29852643894ul, 29852643954ul, 29852643837ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(29852643841ul, 29852643776ul, 29852643812ul, 29852643761ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(4398046511269ul, 4398046511237ul, 4398046511297ul, 4398046511180ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(4398046511184ul, 4398046511119ul, 4398046511155ul, 4398046511104ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(3948976685311ul, 3948976685279ul, 3948976685339ul, 3948976685222ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(3948976685226ul, 3948976685161ul, 3948976685197ul, 3948976685146ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(135763469567146371ul, 135763469567146339ul, 135763469567146399ul, 135763469567146282ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(135763469567146286ul, 135763469567146221ul, 135763469567146257ul, 135763469567146206ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul + u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(11654173250180970174ul, 11654173250180970142ul, 11654173250180970202ul, 11654173250180970085ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul + u64vec4(80ul, 15ul, 51ul, 0ul)), u64vec4(11654173250180970089ul, 11654173250180970024ul, 11654173250180970060ul, 11654173250180970009ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
