# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.fabric.nodes.network.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Interfaces(VapiInterface):
    """
    
    """
    LIST_ADMIN_STATUS_UP = "UP"
    """
    Possible value for ``adminStatus`` of method :func:`Interfaces.list`.

    """
    LIST_ADMIN_STATUS_DOWN = "DOWN"
    """
    Possible value for ``adminStatus`` of method :func:`Interfaces.list`.

    """
    LIST_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`Interfaces.list`.

    """
    LIST_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`Interfaces.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.fabric.nodes.network.interfaces'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _InterfacesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             node_id,
             admin_status=None,
             source=None,
             ):
        """
        Returns the number of interfaces on the node and detailed information
        about each interface. Interface information includes MTU, broadcast and
        host IP addresses, link and admin status, MAC address, network mask,
        and the IP configuration method (static or DHCP). 
        This api is deprecated. Please use Transport Node API GET
        /transport-nodes/<transport-node-id>/network/interfaces to list node
        network interfaces for the corresponding TN.

        .. deprecated:: unknown

        :type  node_id: :class:`str`
        :param node_id: (required)
        :type  admin_status: :class:`str` or ``None``
        :param admin_status: Admin status of the interface (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :rtype: :class:`com.vmware.nsx.model_client.NodeInterfacePropertiesListResult`
        :return: com.vmware.nsx.model.NodeInterfacePropertiesListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.fabric.nodes.network.Interfaces.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'node_id': node_id,
                            'admin_status': admin_status,
                            'source': source,
                            })
class _InterfacesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'node_id': type.StringType(),
            'admin_status': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/fabric/nodes/{node-id}/network/interfaces',
            path_variables={
                'node_id': 'node-id',
            },
             header_parameters={
                   },
            query_parameters={
                'admin_status': 'admin_status',
                'source': 'source',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NodeInterfacePropertiesListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.fabric.nodes.network.interfaces',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Interfaces': Interfaces,
    }

