# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.lb_services.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class DetailedStatus(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`DetailedStatus.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`DetailedStatus.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_services.detailed_status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DetailedStatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            lb_service_id,
            enforcement_point_path=None,
            include_instance_details=None,
            source=None,
            transport_node_ids=None,
            ):
        """
        Get LBService detailed status information. - no enforcement point path
        specified: Information will be aggregated from each enforcement point.
        - {enforcement_point_path}: Information will be retrieved only from the
        given enforcement point. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService id (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_instance_details: :class:`bool` or ``None``
        :param include_instance_details: Flag to indicate whether include detail information (optional,
            default to false)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :type  transport_node_ids: :class:`str` or ``None``
        :param transport_node_ids: The UUIDs of transport nodes (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateLBServiceStatus`
        :return: com.vmware.nsx_policy.model.AggregateLBServiceStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_service_id': lb_service_id,
                            'enforcement_point_path': enforcement_point_path,
                            'include_instance_details': include_instance_details,
                            'source': source,
                            'transport_node_ids': transport_node_ids,
                            })
class ServiceUsage(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`ServiceUsage.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`ServiceUsage.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_services.service_usage'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServiceUsageStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            lb_service_id,
            enforcement_point_path=None,
            source=None,
            ):
        """
        Get LBServiceUsage information. - no enforcement point path specified:
        Information will be aggregated from each enforcement point. -
        {enforcement_point_path}: Information will be retrieved only from the
        given enforcement point. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService id (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateLBServiceUsage`
        :return: com.vmware.nsx_policy.model.AggregateLBServiceUsage
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_service_id': lb_service_id,
                            'enforcement_point_path': enforcement_point_path,
                            'source': source,
                            })
class Statistics(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_services.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            lb_service_id,
            enforcement_point_path=None,
            source=None,
            ):
        """
        Get LBServiceStatistics information. - no enforcement point path
        specified: Information will be aggregated from each enforcement point.
        - {enforcement_point_path}: Information will be retrieved only from the
        given enforcement point. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService id (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateLBServiceStatistics`
        :return: com.vmware.nsx_policy.model.AggregateLBServiceStatistics
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'lb_service_id': lb_service_id,
                            'enforcement_point_path': enforcement_point_path,
                            'source': source,
                            })
class _DetailedStatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'lb_service_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'include_instance_details': type.OptionalType(type.BooleanType()),
            'source': type.OptionalType(type.StringType()),
            'transport_node_ids': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/lb-services/{lb-service-id}/detailed-status',
            path_variables={
                'lb_service_id': 'lb-service-id',
            },
             header_parameters={
                       },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
                'include_instance_details': 'include_instance_details',
                'source': 'source',
                'transport_node_ids': 'transport_node_ids',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateLBServiceStatus'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.lb_services.detailed_status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ServiceUsageStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'lb_service_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/lb-services/{lb-service-id}/service-usage',
            path_variables={
                'lb_service_id': 'lb-service-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
                'source': 'source',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateLBServiceUsage'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.lb_services.service_usage',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'lb_service_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/lb-services/{lb-service-id}/statistics',
            path_variables={
                'lb_service_id': 'lb-service-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
                'source': 'source',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateLBServiceStatistics'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.lb_services.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'DetailedStatus': DetailedStatus,
        'ServiceUsage': ServiceUsage,
        'Statistics': Statistics,
        'lb_pools': 'com.vmware.nsx_policy.infra.lb_services.lb_pools_client.StubFactory',
        'lb_virtual_servers': 'com.vmware.nsx_policy.infra.lb_services.lb_virtual_servers_client.StubFactory',
    }

