# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.nvds_urt.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Precheck(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.precheck'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrecheckStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Retrieve latest precheck ID of the N-VDS to VDS migration 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown


        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx_policy.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.Precheck.get is deprecated.', DeprecationWarning)
        return self._invoke('get', None)

    def update(self,
               tolerate_different_configurations=None,
               ):
        """
        Start precheck for N-VDS to VDS migration 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  tolerate_different_configurations: :class:`bool` or ``None``
        :param tolerate_different_configurations: tolerate differnet configurations (optional, default to true)
        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx_policy.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.Precheck.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'tolerate_different_configurations': tolerate_different_configurations,
                            })
class PrecheckByCluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.precheck_by_cluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrecheckByClusterStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            cluster_id,
            ):
        """
        Retrieve latest precheck ID of the N-VDS to VDS migration for the
        cluster 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  cluster_id: :class:`str`
        :param cluster_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx_policy.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.PrecheckByCluster.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'cluster_id': cluster_id,
                            })

    def update(self,
               cluster_id,
               tolerate_different_configurations=None,
               ):
        """
        Start precheck for N-VDS to VDS migration by cluster 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  cluster_id: :class:`str`
        :param cluster_id: (required)
        :type  tolerate_different_configurations: :class:`bool` or ``None``
        :param tolerate_different_configurations: tolerate differnet configurations (optional, default to true)
        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx_policy.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.PrecheckByCluster.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'cluster_id': cluster_id,
                            'tolerate_different_configurations': tolerate_different_configurations,
                            })
class PrecheckByClusters(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.precheck_by_clusters'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrecheckByClustersStub)
        self._VAPI_OPERATION_IDS = {}


    def update(self,
               precheck_parameters,
               tolerate_different_configurations=None,
               ):
        """
        Start precheck for N-VDS to VDS migration by clusters 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  precheck_parameters: :class:`com.vmware.nsx_policy.model_client.PrecheckParameters`
        :param precheck_parameters: (required)
        :type  tolerate_different_configurations: :class:`bool` or ``None``
        :param tolerate_different_configurations: tolerate differnet configurations (optional, default to true)
        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx_policy.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.PrecheckByClusters.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'precheck_parameters': precheck_parameters,
                            'tolerate_different_configurations': tolerate_different_configurations,
                            })
class StatusSummary(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.status_summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusSummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            precheck_id,
            cluster_id=None,
            ):
        """
        Get summary of N-VDS to VDS migration 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradeStatusSummary`
        :return: com.vmware.nsx_policy.model.NvdsUpgradeStatusSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.StatusSummary.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            'cluster_id': cluster_id,
                            })
class StatusSummaryByCluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.status_summary_by_cluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusSummaryByClusterStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            precheck_id,
            ):
        """
        Get summary of N-VDS to VDS migration 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.NvdsUpgradeStatusSummary`
        :return: com.vmware.nsx_policy.model.NvdsUpgradeStatusSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.StatusSummaryByCluster.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            })
class Topology(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.topology'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TopologyStub)
        self._VAPI_OPERATION_IDS = {}


    def apply(self,
              upgrade_topology,
              cluster_id=None,
              use_recommended_topology_config=None,
              ):
        """
        Set VDS configuration and create it in vCenter 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  upgrade_topology: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :param upgrade_topology: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  use_recommended_topology_config: :class:`bool` or ``None``
        :param use_recommended_topology_config: Flag to indicate if use recommended topology got from the latest
            precheck (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :return: com.vmware.nsx_policy.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.Topology.apply is deprecated.', DeprecationWarning)
        return self._invoke('apply',
                            {
                            'upgrade_topology': upgrade_topology,
                            'cluster_id': cluster_id,
                            'use_recommended_topology_config': use_recommended_topology_config,
                            })

    def get(self,
            precheck_id,
            cluster_id=None,
            compute_manager_id=None,
            show_vds_config=None,
            ):
        """
        Recommmended topology 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  compute_manager_id: :class:`str` or ``None``
        :param compute_manager_id: vCenter identifier (optional)
        :type  show_vds_config: :class:`bool` or ``None``
        :param show_vds_config: Flag to indicate if VdsTopology should contain VDS configuration
            (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :return: com.vmware.nsx_policy.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.Topology.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            'cluster_id': cluster_id,
                            'compute_manager_id': compute_manager_id,
                            'show_vds_config': show_vds_config,
                            })

    def revert(self,
               upgrade_topology,
               ):
        """
        Unset VDS configuration and remove it from vCenter 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  upgrade_topology: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :param upgrade_topology: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :return: com.vmware.nsx_policy.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.Topology.revert is deprecated.', DeprecationWarning)
        return self._invoke('revert',
                            {
                            'upgrade_topology': upgrade_topology,
                            })
class TopologyByCluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt.topology_by_cluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TopologyByClusterStub)
        self._VAPI_OPERATION_IDS = {}


    def apply(self,
              precheck_id,
              upgrade_topology,
              cluster_id=None,
              use_recommended_topology_config=None,
              ):
        """
        Set VDS configuration and create it in vCenter 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  upgrade_topology: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :param upgrade_topology: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  use_recommended_topology_config: :class:`bool` or ``None``
        :param use_recommended_topology_config: Flag to indicate if use recommended topology got from the latest
            precheck (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :return: com.vmware.nsx_policy.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.TopologyByCluster.apply is deprecated.', DeprecationWarning)
        return self._invoke('apply',
                            {
                            'precheck_id': precheck_id,
                            'upgrade_topology': upgrade_topology,
                            'cluster_id': cluster_id,
                            'use_recommended_topology_config': use_recommended_topology_config,
                            })

    def get(self,
            precheck_id,
            cluster_id=None,
            compute_manager_id=None,
            show_vds_config=None,
            ):
        """
        Recommmended topology 
         NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  compute_manager_id: :class:`str` or ``None``
        :param compute_manager_id: vCenter identifier (optional)
        :type  show_vds_config: :class:`bool` or ``None``
        :param show_vds_config: Flag to indicate if VdsTopology should contain VDS configuration
            (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.UpgradeTopology`
        :return: com.vmware.nsx_policy.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.nvds_urt.TopologyByCluster.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            'cluster_id': cluster_id,
                            'compute_manager_id': compute_manager_id,
                            'show_vds_config': show_vds_config,
                            })
class _PrecheckStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/nvds-urt/precheck',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'tolerate_different_configurations': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/nvds-urt/precheck',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'tolerate_different_configurations': 'tolerate_different_configurations',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradePrecheckId'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradePrecheckId'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.precheck',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PrecheckByClusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'cluster_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/nvds-urt/precheck-by-cluster/{cluster_id}',
            path_variables={
                'cluster_id': 'cluster_id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'cluster_id': type.StringType(),
            'tolerate_different_configurations': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/nvds-urt/precheck-by-cluster/{cluster_id}',
            path_variables={
                'cluster_id': 'cluster_id',
            },
             header_parameters={
                 },
            query_parameters={
                'tolerate_different_configurations': 'tolerate_different_configurations',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradePrecheckId'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradePrecheckId'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.precheck_by_cluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PrecheckByClustersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'precheck_parameters': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PrecheckParameters'),
            'tolerate_different_configurations': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/nvds-urt/precheck-by-clusters',
            request_body_parameter='precheck_parameters',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'tolerate_different_configurations': 'tolerate_different_configurations',
            },
            content_type='application/json'
        )

        operations = {
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradePrecheckId'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.precheck_by_clusters',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusSummaryStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'cluster_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/nvds-urt/status-summary/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                 },
            query_parameters={
                'cluster_id': 'cluster_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradeStatusSummary'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.status_summary',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusSummaryByClusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/nvds-urt/status-summary-by-cluster/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'NvdsUpgradeStatusSummary'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.status_summary_by_cluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TopologyStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for apply operation
        apply_input_type = type.StructType('operation-input', {
            'upgrade_topology': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
            'cluster_id': type.OptionalType(type.StringType()),
            'use_recommended_topology_config': type.OptionalType(type.BooleanType()),
        })
        apply_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        apply_input_value_validator_list = [
        ]
        apply_output_validator_list = [
        ]
        apply_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/nvds-urt/topology?action=apply',
            request_body_parameter='upgrade_topology',
            path_variables={
            },
             header_parameters={
                   },
            query_parameters={
                'cluster_id': 'cluster_id',
                'use_recommended_topology_config': 'use_recommended_topology_config',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'cluster_id': type.OptionalType(type.StringType()),
            'compute_manager_id': type.OptionalType(type.StringType()),
            'show_vds_config': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/nvds-urt/topology/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cluster_id': 'cluster_id',
                'compute_manager_id': 'compute_manager_id',
                'show_vds_config': 'show_vds_config',
            },
            content_type='application/json'
        )

        # properties for revert operation
        revert_input_type = type.StructType('operation-input', {
            'upgrade_topology': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
        })
        revert_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        revert_input_value_validator_list = [
        ]
        revert_output_validator_list = [
        ]
        revert_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/nvds-urt/topology?action=revert',
            request_body_parameter='upgrade_topology',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'apply': {
                'input_type': apply_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
                'errors': apply_error_dict,
                'input_value_validator_list': apply_input_value_validator_list,
                'output_validator_list': apply_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'revert': {
                'input_type': revert_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
                'errors': revert_error_dict,
                'input_value_validator_list': revert_input_value_validator_list,
                'output_validator_list': revert_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'apply': apply_rest_metadata,
            'get': get_rest_metadata,
            'revert': revert_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.topology',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TopologyByClusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for apply operation
        apply_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'upgrade_topology': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
            'cluster_id': type.OptionalType(type.StringType()),
            'use_recommended_topology_config': type.OptionalType(type.BooleanType()),
        })
        apply_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        apply_input_value_validator_list = [
        ]
        apply_output_validator_list = [
        ]
        apply_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/nvds-urt/topology-by-cluster/{precheck-id}?action=apply',
            request_body_parameter='upgrade_topology',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cluster_id': 'cluster_id',
                'use_recommended_topology_config': 'use_recommended_topology_config',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'cluster_id': type.OptionalType(type.StringType()),
            'compute_manager_id': type.OptionalType(type.StringType()),
            'show_vds_config': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/nvds-urt/topology-by-cluster/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cluster_id': 'cluster_id',
                'compute_manager_id': 'compute_manager_id',
                'show_vds_config': 'show_vds_config',
            },
            content_type='application/json'
        )

        operations = {
            'apply': {
                'input_type': apply_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
                'errors': apply_error_dict,
                'input_value_validator_list': apply_input_value_validator_list,
                'output_validator_list': apply_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UpgradeTopology'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'apply': apply_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.nvds_urt.topology_by_cluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Precheck': Precheck,
        'PrecheckByCluster': PrecheckByCluster,
        'PrecheckByClusters': PrecheckByClusters,
        'StatusSummary': StatusSummary,
        'StatusSummaryByCluster': StatusSummaryByCluster,
        'Topology': Topology,
        'TopologyByCluster': TopologyByCluster,
    }

