/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStrategy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final ShardHandler shardHandler;
    private volatile boolean isClosed;
    private final HttpClient client;
    private final ExecutorService updateExecutor;
    private final List<RecoveryRequest> recoveryRequests = new ArrayList<RecoveryRequest>();

    public SyncStrategy(CoreContainer cc) {
        UpdateShardHandler updateShardHandler = cc.getUpdateShardHandler();
        this.client = updateShardHandler.getDefaultHttpClient();
        this.shardHandler = cc.getShardHandlerFactory().getShardHandler();
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
    }

    public PeerSync.PeerSyncResult sync(ZkController zkController, SolrCore core, ZkNodeProps leaderProps) {
        return this.sync(zkController, core, leaderProps, false);
    }

    public PeerSync.PeerSyncResult sync(ZkController zkController, SolrCore core, ZkNodeProps leaderProps, boolean peerSyncOnlyWithActive) {
        if (this.SKIP_AUTO_RECOVERY) {
            return PeerSync.PeerSyncResult.success();
        }
        if (this.isClosed) {
            log.warn("Closed, skipping sync up.");
            return PeerSync.PeerSyncResult.failure();
        }
        this.recoveryRequests.clear();
        if (log.isInfoEnabled()) {
            log.info("Sync replicas to {}", (Object)ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps));
        }
        if (core.getUpdateHandler().getUpdateLog() == null) {
            log.error("No UpdateLog found - cannot sync");
            return PeerSync.PeerSyncResult.failure();
        }
        return this.syncReplicas(zkController, core, leaderProps, peerSyncOnlyWithActive);
    }

    private PeerSync.PeerSyncResult syncReplicas(ZkController zkController, SolrCore core, ZkNodeProps leaderProps, boolean peerSyncOnlyWithActive) {
        if (this.isClosed) {
            log.info("We have been closed, won't sync with replicas");
            return PeerSync.PeerSyncResult.failure();
        }
        boolean success = false;
        PeerSync.PeerSyncResult result = null;
        assert (core != null);
        assert (core.getCoreDescriptor() != null);
        CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        try {
            result = this.syncWithReplicas(zkController, core, leaderProps, collection, shardId, peerSyncOnlyWithActive);
            success = result.isSuccess();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Sync Failed", (Throwable)e);
        }
        try {
            if (this.isClosed) {
                log.info("We have been closed, won't attempt to sync replicas back to leader");
                return PeerSync.PeerSyncResult.failure();
            }
            if (success) {
                log.info("Sync Success - now sync replicas to me");
                this.syncToMe(zkController, collection, shardId, leaderProps, core.getCoreDescriptor(), core.getUpdateHandler().getUpdateLog().getNumRecordsToKeep());
            } else {
                log.info("Leader's attempt to sync with shard failed, moving to the next candidate");
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Sync Failed", (Throwable)e);
        }
        return result == null ? PeerSync.PeerSyncResult.failure() : result;
    }

    private PeerSync.PeerSyncResult syncWithReplicas(ZkController zkController, SolrCore core, ZkNodeProps props, String collection, String shardId, boolean peerSyncOnlyWithActive) throws Exception {
        List nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
        if (this.isClosed) {
            log.info("We have been closed, won't sync with replicas");
            return PeerSync.PeerSyncResult.failure();
        }
        if (nodes == null) {
            return PeerSync.PeerSyncResult.success();
        }
        ArrayList<String> syncWith = new ArrayList<String>(nodes.size());
        for (ZkCoreNodeProps node : nodes) {
            syncWith.add(node.getCoreUrl());
        }
        try (PeerSync peerSync = new PeerSync(core, syncWith, core.getUpdateHandler().getUpdateLog().getNumRecordsToKeep(), true, peerSyncOnlyWithActive, false);){
            PeerSync.PeerSyncResult peerSyncResult = peerSync.sync();
            return peerSyncResult;
        }
    }

    private void syncToMe(ZkController zkController, String collection, String shardId, ZkNodeProps leaderProps, CoreDescriptor cd, int nUpdates) {
        ShardResponse srsp;
        if (this.isClosed) {
            log.info("We have been closed, won't sync replicas to me.");
            return;
        }
        List nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, cd.getCloudDescriptor().getCoreNodeName());
        if (nodes == null) {
            if (log.isInfoEnabled()) {
                log.info("{} has no replicas", (Object)ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps));
            }
            return;
        }
        ZkCoreNodeProps zkLeader = new ZkCoreNodeProps(leaderProps);
        for (ZkCoreNodeProps node : nodes) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("{}: try and ask {} to sync", (Object)ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps), (Object)node.getCoreUrl());
                }
                this.requestSync(node.getBaseUrl(), node.getCoreUrl(), zkLeader.getCoreUrl(), node.getCoreName(), nUpdates);
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error syncing replica to leader", (Throwable)e);
            }
        }
        while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
            boolean success = this.handleResponse(srsp);
            if (srsp.getException() != null) {
                SolrException.log((Logger)log, (String)("Sync request error: " + srsp.getException()));
            }
            if (!success) {
                if (log.isInfoEnabled()) {
                    log.info("{}: Sync failed - we will ask replica ({}) to recover.", (Object)ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps), (Object)srsp.getShardAddress());
                }
                if (this.isClosed) {
                    log.info("We have been closed, don't request that a replica recover");
                    continue;
                }
                RecoveryRequest rr = new RecoveryRequest();
                rr.leaderProps = leaderProps;
                rr.baseUrl = ((ShardCoreRequest)srsp.getShardRequest()).baseUrl;
                rr.coreName = ((ShardCoreRequest)srsp.getShardRequest()).coreName;
                this.recoveryRequests.add(rr);
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info("{}: sync completed with {}", (Object)ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps), (Object)srsp.getShardAddress());
        }
    }

    private boolean handleResponse(ShardResponse srsp) {
        NamedList response = srsp.getSolrResponse().getResponse();
        if (response == null) {
            return false;
        }
        Boolean success = (Boolean)response.get("sync");
        if (success == null) {
            success = false;
        }
        return success;
    }

    private void requestSync(String baseUrl, String replica, String leaderUrl, String coreName, int nUpdates) {
        ShardCoreRequest sreq = new ShardCoreRequest();
        sreq.coreName = coreName;
        sreq.baseUrl = baseUrl;
        sreq.purpose = 1;
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", new String[]{Integer.toString(nUpdates)});
        sreq.params.set("sync", new String[]{leaderUrl});
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    public void close() {
        this.isClosed = true;
    }

    public void requestRecoveries() {
        for (RecoveryRequest rr : this.recoveryRequests) {
            try {
                this.requestRecovery(rr.leaderProps, rr.baseUrl, rr.coreName);
            }
            catch (IOException | SolrServerException e) {
                log.error("Problem requesting that a replica recover", e);
            }
        }
    }

    @SuppressForbidden(reason="Passed to an executor with a naming thread factory")
    private void requestRecovery(ZkNodeProps leaderProps, String baseUrl, String coreName) throws SolrServerException, IOException {
        Thread thread = new Thread(() -> {
            block9: {
                if (this.isClosed) {
                    log.info("We have been closed, won't request recovery");
                    return;
                }
                CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
                recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
                recoverRequestCmd.setCoreName(coreName);
                try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(baseUrl).withHttpClient(this.client)).withConnectionTimeout(30000)).withSocketTimeout(120000)).build();){
                    client.request((SolrRequest)recoverRequestCmd);
                }
                catch (Throwable t) {
                    SolrException.log((Logger)log, (String)(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Could not tell a replica to recover"), (Throwable)t);
                    if (!(t instanceof Error)) break block9;
                    throw (Error)t;
                }
            }
        });
        thread.setDaemon(true);
        this.updateExecutor.execute(thread);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    private static class ShardCoreRequest
    extends ShardRequest {
        String coreName;
        public String baseUrl;

        private ShardCoreRequest() {
        }
    }

    private static class RecoveryRequest {
        ZkNodeProps leaderProps;
        String baseUrl;
        String coreName;

        private RecoveryRequest() {
        }
    }
}

