/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;

public class FacetBucket {
    final FacetModule.FacetBucketMerger parent;
    final Comparable bucketValue;
    final int bucketNumber;
    long count;
    Map<String, FacetMerger> subs;

    public FacetBucket(FacetModule.FacetBucketMerger parent, Comparable bucketValue, FacetMerger.Context mcontext) {
        this.parent = parent;
        this.bucketValue = bucketValue;
        this.bucketNumber = mcontext.getNewBucketNumber();
    }

    public long getCount() {
        return this.count;
    }

    FacetMerger getExistingMerger(String key) {
        if (this.subs == null) {
            return null;
        }
        return this.subs.get(key);
    }

    private FacetMerger getMerger(String key, Object prototype) {
        FacetMerger merger = null;
        if (this.subs != null && (merger = this.subs.get(key)) != null) {
            return merger;
        }
        merger = this.parent.createFacetMerger(key, prototype);
        if (merger != null) {
            if (this.subs == null) {
                this.subs = new HashMap<String, FacetMerger>();
            }
            this.subs.put(key, merger);
        }
        return merger;
    }

    public void mergeBucket(SimpleOrderedMap<?> bucket, FacetMerger.Context mcontext) {
        mcontext.setShardFlag(this.bucketNumber);
        for (int i = 0; i < bucket.size(); ++i) {
            FacetMerger merger;
            String key = bucket.getName(i);
            Object val = bucket.getVal(i);
            if ("count".equals(key)) {
                this.count += ((Number)val).longValue();
                continue;
            }
            if ("val".equals(key) || (merger = this.getMerger(key, val)) == null) continue;
            merger.merge(val, mcontext);
        }
    }

    public SimpleOrderedMap<Object> getMergedBucket() {
        SimpleOrderedMap out = new SimpleOrderedMap((this.subs == null ? 0 : this.subs.size()) + 2);
        if (this.bucketValue != null) {
            out.add("val", (Object)this.bucketValue);
        }
        out.add("count", (Object)this.count);
        if (this.subs != null) {
            for (Map.Entry<String, FacetMerger> mergerEntry : this.subs.entrySet()) {
                FacetMerger subMerger = mergerEntry.getValue();
                Object mergedResult = subMerger.getMergedResult();
                if (null == mergedResult) continue;
                out.add(mergerEntry.getKey(), mergedResult);
            }
        }
        return out;
    }

    public Map<String, Object> getRefinement(FacetMerger.Context mcontext, Collection<String> refineTags) {
        if (this.subs == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> refinement = null;
        for (String tag : refineTags) {
            Map<String, Object> subRef;
            FacetMerger subMerger = this.subs.get(tag);
            if (subMerger == null || (subRef = subMerger.getRefinement(mcontext)) == null) continue;
            if (refinement == null) {
                refinement = new HashMap<String, Map<String, Object>>(refineTags.size());
            }
            refinement.put(tag, subRef);
        }
        return refinement;
    }

    public Map<String, Object> getRefinement2(FacetMerger.Context mcontext, Collection<String> refineTags) {
        boolean parentMissing = mcontext.bucketWasMissing();
        if (!parentMissing) {
            boolean sawThisBucket = mcontext.getShardFlag(this.bucketNumber);
            if (!sawThisBucket) {
                mcontext.setBucketWasMissing(true);
            }
        } else assert (!mcontext.getShardFlag(this.bucketNumber));
        HashMap<String, Object> refinement = null;
        if (!mcontext.bucketWasMissing()) {
            if (this.subs == null || refineTags.isEmpty()) {
                return null;
            }
        } else {
            refineTags = null;
            refinement = new HashMap<String, Object>(4);
            if (this.bucketValue != null) {
                refinement.put("_v", this.bucketValue);
            }
            refinement.put("_m", 1);
        }
        for (Map.Entry<String, FacetMerger> sub : this.subs.entrySet()) {
            Map<String, Object> subRef;
            if (refineTags != null && !refineTags.contains(sub.getKey()) || (subRef = sub.getValue().getRefinement(mcontext)) == null) continue;
            if (refinement == null) {
                refinement = new HashMap(4);
            }
            refinement.put(sub.getKey(), subRef);
        }
        mcontext.setBucketWasMissing(parentMissing);
        return refinement;
    }
}

