/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.quicktime;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.quicktime.QuickTimeReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.file.FileSystemMetadataReader;
import com.drew.metadata.mov.QuickTimeAtomHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class QuickTimeMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        Metadata metadata;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            metadata = QuickTimeMetadataReader.readMetadata(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) {
        Metadata metadata = new Metadata();
        QuickTimeReader.extract(inputStream, new QuickTimeAtomHandler(metadata));
        return metadata;
    }
}

