/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MssqlSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.MSSQL).withIdentifierQuoteString("[").withCaseSensitive(false).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new MssqlSqlDialect(DEFAULT_CONTEXT);
    private static final SqlFunction MSSQL_SUBSTRING = SqlBasicFunction.create("SUBSTRING", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.VARIADIC, SqlFunctionCategory.STRING);
    private final boolean top;

    public MssqlSqlDialect(SqlDialect.Context context) {
        super(context);
        this.top = context.databaseMajorVersion() < 11;
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.nullCollation.isDefaultOrder(nullsFirst, desc)) {
            return null;
        }
        if (node.getKind() == SqlKind.GROUPING) {
            return node;
        }
        SqlParserPos pos = SqlParserPos.ZERO;
        SqlNodeList whenList = SqlNodeList.of(SqlStdOperatorTable.IS_NULL.createCall(pos, node));
        SqlNumericLiteral oneLiteral = SqlLiteral.createExactNumeric("1", pos);
        SqlNumericLiteral zeroLiteral = SqlLiteral.createExactNumeric("0", pos);
        if (nullsFirst) {
            return SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList, SqlNodeList.of(zeroLiteral), oneLiteral);
        }
        return SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList, SqlNodeList.of(oneLiteral), zeroLiteral);
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        if (!this.top && offset != null) {
            super.unparseOffsetFetch(writer, offset, fetch);
        }
    }

    @Override
    public void unparseTopN(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        if (this.top || offset == null) {
            writer.keyword("TOP");
            writer.keyword("(");
            Objects.requireNonNull(fetch, "fetch");
            fetch.unparse(writer, -1, -1);
            writer.keyword(")");
        }
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        writer.literal("'" + literal.toFormattedString() + "'");
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            if (call.operandCount() != 3) {
                throw new IllegalArgumentException("MSSQL SUBSTRING requires FROM and FOR arguments");
            }
            SqlUtil.unparseFunctionSyntax(MSSQL_SUBSTRING, writer, call, false);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    MssqlSqlDialect.unparseFloor(writer, call);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    private static void unparseFloor(SqlWriter writer, SqlCall call) {
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = node.getValueAs(TimeUnitRange.class);
        switch (unit) {
            case YEAR: {
                MssqlSqlDialect.unparseFloorWithUnit(writer, call, 4, "-01-01");
                break;
            }
            case MONTH: {
                MssqlSqlDialect.unparseFloorWithUnit(writer, call, 7, "-01");
                break;
            }
            case WEEK: {
                writer.print("CONVERT(DATETIME, CONVERT(VARCHAR(10), DATEADD(day, - (6 + DATEPART(weekday, ");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.print(")) % 7, ");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.print("), 126))");
                break;
            }
            case DAY: {
                MssqlSqlDialect.unparseFloorWithUnit(writer, call, 10, "");
                break;
            }
            case HOUR: {
                MssqlSqlDialect.unparseFloorWithUnit(writer, call, 13, ":00:00");
                break;
            }
            case MINUTE: {
                MssqlSqlDialect.unparseFloorWithUnit(writer, call, 16, ":00");
                break;
            }
            case SECOND: {
                MssqlSqlDialect.unparseFloorWithUnit(writer, call, 19, ":00");
                break;
            }
            default: {
                throw new IllegalArgumentException("MSSQL does not support FLOOR for time unit: " + unit);
            }
        }
    }

    @Override
    public void unparseSqlDatetimeArithmetic(SqlWriter writer, SqlCall call, SqlKind sqlKind, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall("DATEADD");
        Object operand = call.operand(1);
        if (operand instanceof SqlIntervalLiteral) {
            this.unparseSqlIntervalLiteralMssql(writer, (SqlIntervalLiteral)operand, sqlKind == SqlKind.MINUS ? -1 : 1);
        } else {
            ((SqlNode)operand).unparse(writer, leftPrec, rightPrec);
        }
        writer.sep(",", true);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        switch (qualifier.timeUnitRange) {
            case YEAR: 
            case MONTH: 
            case WEEK: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case QUARTER: 
            case MILLISECOND: 
            case MICROSECOND: {
                String timeUnit = qualifier.timeUnitRange.startUnit.name();
                writer.keyword(timeUnit);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported type: " + qualifier.timeUnitRange));
            }
        }
        if (null != qualifier.timeUnitRange.endUnit) {
            throw new AssertionError((Object)("End unit is not supported now: " + qualifier.timeUnitRange.endUnit));
        }
    }

    @Override
    public void unparseSqlIntervalLiteral(SqlWriter writer, SqlIntervalLiteral literal, int leftPrec, int rightPrec) {
        this.unparseSqlIntervalLiteralMssql(writer, literal, 1);
    }

    private void unparseSqlIntervalLiteralMssql(SqlWriter writer, SqlIntervalLiteral literal, int sign) {
        SqlIntervalLiteral.IntervalValue interval = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
        writer.sep(",", true);
        if (interval.getSign() * sign == -1) {
            writer.print("-");
        }
        writer.literal(interval.getIntervalLiteral());
    }

    private static void unparseFloorWithUnit(SqlWriter writer, SqlCall call, int charLen, String offset) {
        writer.print("CONVERT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        writer.print("DATETIME, CONVERT(VARCHAR(" + charLen + "), ");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.print(", 126)");
        if (offset.length() > 0) {
            writer.print("+'" + offset + "'");
        }
        writer.endList(frame);
    }
}

