/*
 * Decompiled with CFR 0.152.
 */
package tr.model.context;

import org.openide.util.NbBundle;
import tr.util.Observable;
import tr.util.ObservableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
extends ObservableImpl
implements Comparable<Context> {
    private static final String DEFAULT_NAME = "None";
    private static Context def;
    private String name = "";
    private String description = "";
    private Integer id;
    public transient String key;

    public Context(int id) {
        this.id = id;
    }

    public void initID(int id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        if (this.name.equals(DEFAULT_NAME)) {
            return NbBundle.getMessage(Context.class, (String)DEFAULT_NAME);
        }
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (name.equals(this.name)) {
            return;
        }
        if (name.equals(DEFAULT_NAME)) {
            return;
        }
        this.name = name;
        this.notifyObservers((Observable)this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null || description.equals(this.description)) {
            return;
        }
        this.description = description;
        this.notifyObservers((Observable)this);
    }

    public static Context getDefault() {
        if (def == null) {
            def = new Context(9);
            Context.def.name = DEFAULT_NAME;
            Context.def.description = NbBundle.getMessage(Context.class, (String)"No_context");
        }
        return def;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        return object instanceof Context && this.name.equals(((Context)object).name);
    }

    @Override
    public int compareTo(Context context) {
        if (context == null || context.name == null) {
            return -1;
        }
        if (this.name.equals(Context.getDefault().name)) {
            if (context.name.equals(Context.getDefault().name)) {
                return 0;
            }
            return -1;
        }
        if (context.name.equals(Context.getDefault().name)) {
            return 1;
        }
        return this.name.compareToIgnoreCase(context.name);
    }
}

