/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action.executor;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordGroup {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<AbstractRecord> records;

    static final List<RecordGroup> generateRecordGroups(List<AbstractRecord> records) {
        LinkedList<RecordGroup> recordGroups = new LinkedList<RecordGroup>();
        if (records.isEmpty()) {
            return recordGroups;
        }
        RecordGroup group = new RecordGroup();
        recordGroups.add(group);
        for (AbstractRecord record : records) {
            if (group.addRecord(record)) continue;
            group = new RecordGroup();
            recordGroups.add(group);
            group.addRecord(record);
        }
        return recordGroups;
    }

    private RecordGroup() {
        this.records = new LinkedList<AbstractRecord>();
    }

    private RecordGroup(List<AbstractRecord> records) {
        this.records = records;
    }

    public ProtocolMessageType getProtocolMessageType() {
        if (!this.records.isEmpty()) {
            return ProtocolMessageType.getContentType(this.records.get(0).getContentMessageType().getValue());
        }
        return null;
    }

    public Integer getDtlsEpoch() {
        if (!this.records.isEmpty()) {
            return this.getRecordEpoch(this.records.get(0));
        }
        return null;
    }

    private Integer getRecordEpoch(AbstractRecord record) {
        if (record instanceof Record && ((Record)record).getEpoch() != null) {
            return (Integer)((Record)record).getEpoch().getValue();
        }
        return null;
    }

    public List<AbstractRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public byte[] getCleanBytes() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (AbstractRecord record : this.getRecords()) {
            try {
                stream.write((byte[])record.getCleanProtocolMessageBytes().getValue());
            }
            catch (IOException ex) {
                LOGGER.warn("Could not write CleanProtocolMessage bytes to Array");
                LOGGER.debug((Object)ex);
            }
        }
        return stream.toByteArray();
    }

    public void decryptRecords(TlsContext context) {
        for (AbstractRecord record : this.getRecords()) {
            context.getRecordLayer().decryptAndDecompressRecord(record);
        }
    }

    public void adjustContext(TlsContext context) {
        for (AbstractRecord record : this.getRecords()) {
            record.adjustContext(context);
        }
    }

    private boolean addRecord(AbstractRecord record) {
        boolean isFitting = false;
        if (this.records.isEmpty()) {
            isFitting = true;
        } else if (Objects.equals((Object)record.getContentMessageType(), (Object)this.getProtocolMessageType()) && record.getClass().equals(this.records.get(0).getClass())) {
            if (this.getDtlsEpoch() != null) {
                if (Objects.equals(this.getRecordEpoch(record), this.getDtlsEpoch())) {
                    isFitting = true;
                }
            } else {
                isFitting = true;
            }
        }
        if (isFitting) {
            this.records.add(record);
        }
        return isFitting;
    }

    public boolean areAllRecordsValid() {
        for (AbstractRecord record : this.records) {
            if (!this.isRecordInvalid(record)) continue;
            return false;
        }
        return true;
    }

    private boolean isRecordInvalid(AbstractRecord record) {
        RecordCryptoComputations computations;
        return record instanceof Record && (computations = ((Record)record).getComputations()) != null && (Objects.equals(computations.getMacValid(), Boolean.FALSE) || Objects.equals(computations.getPaddingValid(), Boolean.FALSE) || Objects.equals(computations.getAuthenticationTagValid(), Boolean.FALSE));
    }

    public List<RecordGroup> splitIntoProcessableSubgroups() {
        LinkedList<RecordGroup> recordGroupList = new LinkedList<RecordGroup>();
        if (this.areAllRecordsValid()) {
            recordGroupList.add(this);
            return recordGroupList;
        }
        LinkedList<AbstractRecord> recordList = new LinkedList<AbstractRecord>();
        Boolean valid = null;
        for (AbstractRecord record : recordList) {
            boolean tempValid = this.isRecordInvalid(record);
            if (valid == null || Objects.equals(tempValid, valid)) {
                valid = tempValid;
                recordList.add(record);
                continue;
            }
            recordGroupList.add(new RecordGroup(recordList));
            valid = tempValid;
            recordList = new LinkedList();
            recordList.add(record);
        }
        if (!recordList.isEmpty()) {
            recordGroupList.add(new RecordGroup(recordList));
        }
        return recordGroupList;
    }
}

