/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class HereGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String id, String key, String language) {
        if (url == null) {
            url = "https://reverse.geocoder.ls.hereapi.com/6.2/reversegeocode.json";
        }
        url = (String)url + "?mode=retrieveAddresses&maxresults=1";
        url = (String)url + "&prox=%f,%f,0";
        url = (String)url + "&app_id=" + id;
        url = (String)url + "&app_code=" + key;
        url = (String)url + "&apiKey=" + key;
        if (language != null) {
            url = (String)url + "&language=" + language;
        }
        return url;
    }

    public HereGeocoder(Client client, String url, String id, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, HereGeocoder.formatUrl(url, id, key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonObject result = json.getJsonObject("Response").getJsonArray("View").getJsonObject(0).getJsonArray("Result").getJsonObject(0).getJsonObject("Location").getJsonObject("Address");
        if (result != null) {
            Address address = new Address();
            if (result.containsKey((Object)"Label")) {
                address.setFormattedAddress(result.getString("Label"));
            }
            if (result.containsKey((Object)"HouseNumber")) {
                address.setHouse(result.getString("HouseNumber"));
            }
            if (result.containsKey((Object)"Street")) {
                address.setStreet(result.getString("Street"));
            }
            if (result.containsKey((Object)"City")) {
                address.setSettlement(result.getString("City"));
            }
            if (result.containsKey((Object)"District")) {
                address.setDistrict(result.getString("District"));
            }
            if (result.containsKey((Object)"State")) {
                address.setState(result.getString("State"));
            }
            if (result.containsKey((Object)"Country")) {
                address.setCountry(result.getString("Country").toUpperCase());
            }
            if (result.containsKey((Object)"PostalCode")) {
                address.setPostcode(result.getString("PostalCode"));
            }
            return address;
        }
        return null;
    }
}

