/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.beanutils.ConversionException;

public class HeaderCheck
extends Check {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private String[] mHeaderLines = null;
    private int[] mIgnoreLines = EMPTY_INT_ARRAY;

    public int[] getDefaultTokens() {
        return new int[0];
    }

    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.mHeaderLines == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
    }

    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        if (this.mHeaderLines.length > lines.length) {
            this.log(1, "header.missing");
        } else {
            int i = 0;
            while (i < this.mHeaderLines.length) {
                if (!this.isIgnoreLine(i + 1) && !this.isMatch(i)) {
                    this.log(i + 1, "header.mismatch", (Object)this.mHeaderLines[i]);
                    break;
                }
                ++i;
            }
        }
    }

    private boolean isIgnoreLine(int aLineNo) {
        return Arrays.binarySearch(this.mIgnoreLines, aLineNo) >= 0;
    }

    protected boolean isMatch(int aLineNumber) {
        String[] lines = this.getLines();
        return this.mHeaderLines[aLineNumber].equals(lines[aLineNumber]);
    }

    public void setHeaderFile(String aFileName) throws ConversionException {
        if (aFileName == null || aFileName.trim().length() == 0) {
            return;
        }
        try {
            String l;
            LineNumberReader lnr = new LineNumberReader(new FileReader(aFileName));
            ArrayList<String> lines = new ArrayList<String>();
            while ((l = lnr.readLine()) != null) {
                lines.add(l);
            }
            this.mHeaderLines = lines.toArray(new String[0]);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header file " + aFileName, ex);
        }
    }

    public void setIgnoreLines(int[] aList) {
        if (aList == null || aList.length == 0) {
            this.mIgnoreLines = EMPTY_INT_ARRAY;
            return;
        }
        this.mIgnoreLines = new int[aList.length];
        System.arraycopy(aList, 0, this.mIgnoreLines, 0, aList.length);
        Arrays.sort(this.mIgnoreLines);
    }

    protected String[] getHeaderLines() {
        return this.mHeaderLines;
    }
}

