/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

public class TransactionEvent {
    private final Object source;
    private final String message;
    private final TransactionState state;

    public static TransactionEvent createStartTransactionEvent(Object source, String message) {
        return new TransactionEvent(source, message, TransactionState.START);
    }

    @Deprecated
    public static TransactionEvent createEndTransactionEvent(Object source) {
        return new TransactionEvent(source);
    }

    public static TransactionEvent createEndTransactionEvent(Object source, String message) {
        return new TransactionEvent(source, message, TransactionState.END);
    }

    public static TransactionEvent createRollbackTransactionEvent(Object source, String message) {
        return new TransactionEvent(source, message, TransactionState.ROLLBACK);
    }

    private TransactionEvent(Object source, String message, TransactionState state) {
        this.source = source;
        this.message = message;
        this.state = state;
    }

    private TransactionEvent(Object source) {
        this.source = source;
        this.message = "";
        this.state = TransactionState.END;
    }

    public Object getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public TransactionState getState() {
        return this.state;
    }

    public static enum TransactionState {
        START,
        END,
        ROLLBACK;

    }
}

