/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.io.File;
import org.jboss.logmanager.config.ValueExpressionImpl;

public interface ValueExpression<T> {
    public static final ValueExpression<String> NULL_STRING_EXPRESSION = new ValueExpression<String>(){

        @Override
        public String getResolvedValue() {
            return null;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public String getValue() {
            return null;
        }
    };
    public static final ValueExpression<Boolean> NULL_BOOLEAN_EXPRESSION = new ValueExpression<Boolean>(){

        @Override
        public Boolean getResolvedValue() {
            return null;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public String getValue() {
            return null;
        }
    };
    public static final Resolver<String> STRING_RESOLVER = new Resolver<String>(){
        private static final int INITIAL = 0;
        private static final int GOT_DOLLAR = 1;
        private static final int GOT_OPEN_BRACE = 2;
        private static final int RESOLVED = 3;
        private static final int DEFAULT = 4;

        @Override
        public ValueExpression<String> resolve(String expression) {
            if (expression == null) {
                return NULL_STRING_EXPRESSION;
            }
            boolean isExpression = false;
            StringBuilder builder = new StringBuilder();
            char[] chars = expression.toCharArray();
            int len = chars.length;
            int state = 0;
            int start = -1;
            int nameStart = -1;
            block21: for (int i = 0; i < len; ++i) {
                char ch = chars[i];
                switch (state) {
                    case 0: {
                        switch (ch) {
                            case '$': {
                                state = 1;
                                continue block21;
                            }
                        }
                        builder.append(ch);
                        continue block21;
                    }
                    case 1: {
                        switch (ch) {
                            case '$': {
                                builder.append(ch);
                                state = 0;
                                continue block21;
                            }
                            case '{': {
                                nameStart = start = i + 1;
                                state = 2;
                                continue block21;
                            }
                        }
                        builder.append('$').append(ch);
                        state = 0;
                        continue block21;
                    }
                    case 2: {
                        switch (ch) {
                            case ',': 
                            case ':': 
                            case '}': {
                                String name = expression.substring(nameStart, i).trim();
                                if ("/".equals(name)) {
                                    builder.append(File.separator);
                                    state = ch == '}' ? 0 : 3;
                                    continue block21;
                                }
                                if (":".equals(name)) {
                                    builder.append(File.pathSeparator);
                                    state = ch == '}' ? 0 : 3;
                                    continue block21;
                                }
                                isExpression = true;
                                String val = System.getProperty(name);
                                if (val == null && name.startsWith("env.")) {
                                    val = System.getenv(name);
                                }
                                if (val != null) {
                                    builder.append(val);
                                    state = ch == '}' ? 0 : 3;
                                    continue block21;
                                }
                                if (ch == ',') {
                                    nameStart = i + 1;
                                    continue block21;
                                }
                                if (ch == ':') {
                                    start = i + 1;
                                    state = 4;
                                    continue block21;
                                }
                                builder.append(expression.substring(start - 2, i + 1));
                                state = 0;
                                continue block21;
                            }
                        }
                        continue block21;
                    }
                    case 3: {
                        if (ch != '}') continue block21;
                        state = 0;
                        continue block21;
                    }
                    case 4: {
                        if (ch != '}') continue block21;
                        state = 0;
                        builder.append(expression.substring(start, i));
                        continue block21;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (state) {
                case 1: {
                    builder.append('$');
                    break;
                }
                case 2: 
                case 4: {
                    builder.append(expression.substring(start - 2));
                }
            }
            String resolvedValue = builder.toString();
            if (isExpression) {
                return new ValueExpressionImpl<String>(expression, resolvedValue);
            }
            return new ValueExpressionImpl<String>(null, resolvedValue);
        }
    };
    public static final Resolver<Boolean> BOOLEAN_RESOLVER = new Resolver<Boolean>(){

        @Override
        public ValueExpression<Boolean> resolve(String expression) {
            if (expression == null) {
                return NULL_BOOLEAN_EXPRESSION;
            }
            ValueExpression<String> stringResult = STRING_RESOLVER.resolve(expression);
            Boolean value = stringResult.getResolvedValue() == null ? null : Boolean.valueOf(stringResult.getResolvedValue());
            return new ValueExpressionImpl<Boolean>(expression, value);
        }
    };

    public T getResolvedValue();

    public boolean isExpression();

    public String getValue();

    public String toString();

    public static interface Resolver<T> {
        public ValueExpression<T> resolve(String var1);
    }
}

