/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.sip.address.Hop;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable,
RawMessageChannel {
    private static final StackLogger logger = CommonLogger.getLogger(UDPMessageChannel.class);
    protected SIPTransactionStack sipStack;
    protected MessageParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private DatagramPacket incomingPacket;
    private long receptionTime;
    private Thread mythread = null;
    private static Hashtable<String, PingBackTimerTask> pingBackRecord = new Hashtable();

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, String threadName) {
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myParser = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
        this.mythread = new Thread(this);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.mythread.setName(threadName);
        this.mythread.setDaemon(true);
        this.mythread.start();
    }

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, DatagramPacket packet) {
        this.incomingPacket = packet;
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myParser = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.start();
    }

    protected UDPMessageChannel(InetAddress targetAddr, int port2, SIPTransactionStack sipStack, UDPMessageProcessor messageProcessor) {
        this.peerAddress = targetAddr;
        this.peerPort = port2;
        this.peerProtocol = "UDP";
        this.messageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.sipStack = sipStack;
        this.myParser = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating message channel " + targetAddr.getHostAddress() + "/" + port2);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        threadHandle = null;
        udpMessageProcessor = (UDPMessageProcessor)this.messageProcessor;
        while (true) {
            packet = null;
            if (this.sipStack.threadPoolSize != -1) {
                if (threadHandle == null && this.sipStack.getThreadAuditor() != null) {
                    threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
                }
                if (threadHandle != null) {
                    threadHandle.ping();
                }
                try {
                    work = null;
                    work = threadHandle != null && this.sipStack.getThreadAuditor() != null && this.sipStack.getThreadAuditor().isEnabled() != false ? udpMessageProcessor.messageQueue.poll(threadHandle.getPingIntervalInMillisecs(), TimeUnit.MILLISECONDS) : udpMessageProcessor.messageQueue.take();
                    if (!udpMessageProcessor.isRunning) {
                        return;
                    }
                    if (work == null) continue;
                    packet = work.packet;
                    this.incomingPacket = work.packet;
                }
                catch (InterruptedException ex) {
                    if (udpMessageProcessor.isRunning) ** GOTO lbl23
                    return;
                }
            } else {
                packet = this.incomingPacket;
            }
lbl23:
            // 3 sources

            try {
                this.processIncomingDataPacket(packet);
            }
            catch (Exception e) {
                UDPMessageChannel.logger.logError("Error while processing incoming UDP packet" + Arrays.toString(packet.getData()), e);
            }
            if (this.sipStack.threadPoolSize == -1) break;
        }
    }

    private void processIncomingDataPacket(DatagramPacket packet) throws Exception {
        this.peerAddress = packet.getAddress();
        int packetLength = packet.getLength();
        byte[] bytes = packet.getData();
        byte[] msgBytes = new byte[packetLength];
        System.arraycopy(bytes, 0, msgBytes, 0, packetLength);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("UDPMessageChannel: processIncomingDataPacket : peerAddress = " + this.peerAddress.getHostAddress() + "/" + packet.getPort() + " Length = " + packetLength);
        }
        SIPMessage sipMessage = null;
        try {
            this.receptionTime = System.currentTimeMillis();
            sipMessage = this.myParser.parseSIPMessage(msgBytes, true, false, this);
            if (sipMessage instanceof SIPRequest) {
                String cseqMethod;
                String sipVersion = ((SIPRequest)sipMessage).getRequestLine().getSipVersion();
                if (!sipVersion.equals("SIP/2.0")) {
                    SIPResponse versionNotSupported = ((SIPRequest)sipMessage).createResponse(505, "Bad version " + sipVersion);
                    this.sendMessage(((Object)versionNotSupported).toString().getBytes(), this.peerAddress, packet.getPort(), "UDP", false);
                    return;
                }
                String method = ((SIPRequest)sipMessage).getMethod();
                if (!method.equalsIgnoreCase(cseqMethod = ((SIPRequest)sipMessage).getCSeqHeader().getMethod())) {
                    SIPResponse sipResponse = ((SIPRequest)sipMessage).createResponse(400);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, this.peerAddress, packet.getPort(), "UDP", false);
                    return;
                }
            }
        }
        catch (ParseException ex) {
            String msgString;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Rejecting message !  " + new String(msgBytes));
                logger.logDebug("error message " + ex.getMessage());
                logger.logException(ex);
            }
            if (!(msgString = new String(msgBytes, 0, packetLength)).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Sending automatic 400 Bad Request:");
                        logger.logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.peerAddress, packet.getPort(), "UDP", false);
                    }
                    catch (IOException e) {
                        logger.logException(e);
                    }
                } else if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            return;
        }
        if (sipMessage == null) {
            String key;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Rejecting message !  + Null message parsed.");
            }
            if (pingBackRecord.get(key = packet.getAddress().getHostAddress() + ":" + packet.getPort()) == null && this.sipStack.getMinKeepAliveInterval() > 0L) {
                byte[] retval = "\r\n\r\n".getBytes();
                DatagramPacket keepalive = new DatagramPacket(retval, 0, retval.length, packet.getAddress(), packet.getPort());
                PingBackTimerTask task = new PingBackTimerTask(packet.getAddress().getHostAddress(), packet.getPort());
                pingBackRecord.put(key, task);
                this.sipStack.getTimer().schedule(task, this.sipStack.getMinKeepAliveInterval() * 1000L);
                ((UDPMessageProcessor)this.messageProcessor).sock.send(keepalive);
            } else {
                logger.logDebug("Not sending ping back");
            }
            return;
        }
        Via topMostVia = sipMessage.getTopmostVia();
        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || topMostVia == null) {
            String badmsg = new String(msgBytes);
            if (logger.isLoggingEnabled()) {
                logger.logError("bad message " + badmsg);
                logger.logError(">>> Dropped Bad Msg From = " + sipMessage.getFrom() + "To = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeq = " + sipMessage.getCSeq() + "Via = " + sipMessage.getViaHeaders());
            }
            return;
        }
        if (this.sipStack.sipEventInterceptor != null) {
            this.sipStack.sipEventInterceptor.beforeMessage(sipMessage);
        }
        if (sipMessage instanceof SIPRequest) {
            Hop hop = this.sipStack.addressResolver.resolveAddress(topMostVia.getHop());
            this.peerPort = hop.getPort();
            this.peerProtocol = topMostVia.getTransport();
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            try {
                this.peerAddress = packet.getAddress();
                boolean hasRPort = topMostVia.hasParameter("rport");
                if (this.sipStack.isPatchRport() && !hasRPort && topMostVia.getPort() != this.peerPacketSourcePort) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("setting rport since viaPort " + topMostVia.getPort() + " different than peerPacketSourcePort " + this.peerPacketSourcePort + " so that the response can be routed back");
                    }
                    hasRPort = true;
                }
                if (hasRPort || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                    topMostVia.setParameter("received", this.peerAddress.getHostAddress());
                }
                if (hasRPort) {
                    topMostVia.setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                }
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        } else {
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            this.peerAddress = packet.getAddress();
            this.peerPort = packet.getPort();
            this.peerProtocol = topMostVia.getTransport();
        }
        this.processMessage(sipMessage);
        if (this.sipStack.sipEventInterceptor != null) {
            this.sipStack.sipEventInterceptor.afterMessage(sipMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(SIPMessage sipMessage) {
        sipMessage.setRemoteAddress(this.peerAddress);
        sipMessage.setRemotePort(this.getPeerPort());
        sipMessage.setLocalPort(this.getPort());
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("Setting SIPMessage peerPacketSource to: " + this.peerPacketSourceAddress + ":" + this.peerPacketSourcePort);
        }
        sipMessage.setPeerPacketSourceAddress(this.peerPacketSourceAddress);
        sipMessage.setPeerPacketSourcePort(this.peerPacketSourcePort);
        if (sipMessage instanceof SIPRequest) {
            ServerRequestInterface sipServerRequest;
            SIPRequest sipRequest = (SIPRequest)sipMessage;
            if (logger.isLoggingEnabled(16)) {
                this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, this.receptionTime);
            }
            if ((sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this)) == null) {
                if (logger.isLoggingEnabled()) {
                    logger.logWarning("Null request interface returned -- dropping request");
                }
                return;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
            }
            try {
                sipServerRequest.processRequest(sipRequest, this);
            }
            finally {
                SIPServerTransaction sipServerTx;
                if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                    ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
            }
        } else {
            ServerResponseInterface sipServerResponse;
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            if (logger.isLoggingEnabled(16)) {
                this.sipStack.serverLogger.logMessage((SIPMessage)sipResponse, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, this.receptionTime);
            }
            if ((sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this)) != null) {
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        return;
                    }
                    sipServerResponse.processResponse(sipResponse, this);
                }
                finally {
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    }
                }
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("null sipServerResponse!");
            }
        }
    }

    @Override
    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled()) {
            logger.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            if (logger.isLoggingEnabled()) {
                logger.logError("BAD MESSAGE!");
                logger.logError(message);
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    @Override
    public void sendMessage(final SIPMessage sipMessage) throws IOException {
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            if (sipMessage instanceof SIPRequest && ((SIPRequest)sipMessage).getRequestLine() != null) {
                logger.logStackTrace(16);
            } else {
                logger.logStackTrace(16);
            }
        }
        long time = System.currentTimeMillis();
        try {
            for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                MessageChannel messageChannel;
                if (!messageProcessor.getIpAddress().equals(this.peerAddress) || messageProcessor.getPort() != this.peerPort || !messageProcessor.getTransport().equalsIgnoreCase(this.peerProtocol) || !((messageChannel = messageProcessor.createMessageChannel(this.peerAddress, this.peerPort)) instanceof RawMessageChannel)) continue;
                final RawMessageChannel channel = (RawMessageChannel)((Object)messageChannel);
                Runnable processMessageTask = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                channel.processMessage((SIPMessage)sipMessage.clone());
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggingEnabled(4)) break block2;
                                logger.logError("Error self routing message cause by: ", ex);
                            }
                        }
                    }
                };
                this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Self routing message");
                }
                return;
            }
            byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
            this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof SIPRequest);
            sipMessage.setRemoteAddress(this.peerAddress);
            sipMessage.setRemotePort(this.peerPort);
            sipMessage.setLocalPort(this.getPort());
            sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.logError("An exception occured while sending message", ex);
            throw new IOException("An exception occured while sending message");
        }
        finally {
            if (logger.isLoggingEnabled(16) && !sipMessage.isNullRequest()) {
                this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Sent EMPTY Message");
            }
        }
    }

    @Override
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, boolean reConnect) throws IOException {
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            logger.logStackTrace(16);
        }
        if (peerPort == -1) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + "messageSize =  " + msg.length + " message = " + new String(msg));
            logger.logDebug("*******************\n");
        }
        DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
        try {
            DatagramSocket sock;
            boolean created = false;
            if (this.sipStack.udpFlag) {
                sock = ((UDPMessageProcessor)this.messageProcessor).sock;
            } else {
                sock = new DatagramSocket();
                created = true;
            }
            sock.send(reply);
            if (created) {
                sock.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, String peerProtocol, boolean retry) throws IOException {
        if (peerPort == -1) {
            if (!logger.isLoggingEnabled(32)) throw new IOException("Receiver port not set ");
            logger.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + " messageSize = " + msg.length);
        }
        if (peerProtocol.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
            try {
                DatagramSocket sock = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.sipStack.getNetworkLayer().createDatagramSocket();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
                }
                sock.send(reply);
                if (this.sipStack.udpFlag) return;
                sock.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return;
            }
        } else {
            Socket outputSocket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), peerAddress, peerPort, "tcp", msg, retry, this);
            OutputStream myOutputStream = outputSocket.getOutputStream();
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public String getTransport() {
        return "udp";
    }

    @Override
    public String getHost() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    @Override
    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    @Override
    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    @Override
    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.getKey().equals(that.getKey());
        }
        return retval;
    }

    @Override
    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    @Override
    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    @Override
    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    @Override
    public String getViaHost() {
        return this.myAddress;
    }

    @Override
    public int getViaPort() {
        return this.myPort;
    }

    @Override
    public boolean isReliable() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    @Override
    public void close() {
        if (this.mythread != null) {
            this.mythread.interrupt();
            this.mythread = null;
        }
    }

    class PingBackTimerTask
    extends SIPStackTimerTask {
        String ipAddress;
        int port;

        public PingBackTimerTask(String ipAddress, int port2) {
            this.ipAddress = ipAddress;
            this.port = port2;
        }

        @Override
        public void runTask() {
            pingBackRecord.remove(this.ipAddress + ":" + this.port);
        }

        public int hashCode() {
            return (this.ipAddress + ":" + this.port).hashCode();
        }
    }
}

