/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Index;

public class MsieRule
extends Rule {
    private static final int IEv5 = 53;
    private static final int IEv6 = 54;
    private static final Index<Boolean> __IE6_BadOS = new Index.Builder().caseSensitive(false).with("NT 5.01", Boolean.TRUE).with("NT 5.0", Boolean.TRUE).with("NT 4.0", Boolean.TRUE).with("98", Boolean.TRUE).with("98; Win 9x 4.90", Boolean.TRUE).with("95", Boolean.TRUE).with("CE", Boolean.TRUE).build();
    private static final HttpField CONNECTION_CLOSE = new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
    private static final HttpField VARY_USER_AGENT = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.USER_AGENT.asString());

    public MsieRule() {
        this._handling = false;
        this._terminating = false;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response2) throws IOException {
        int msie;
        Request baseRequest = Request.getBaseRequest(request);
        if (baseRequest == null) {
            return null;
        }
        HttpFields.Mutable reqFields = HttpFields.build(baseRequest.getHttpFields());
        HttpFields.Mutable resFields = baseRequest.getResponse().getHttpFields();
        String userAgent = reqFields.get(HttpHeader.USER_AGENT);
        boolean acceptEncodings = reqFields.contains(HttpHeader.ACCEPT_ENCODING);
        if (acceptEncodings) {
            resFields.ensureField(VARY_USER_AGENT);
        }
        if ((msie = userAgent.indexOf("MSIE")) >= 0) {
            int version2;
            int n = version2 = userAgent.length() - msie > 5 ? (int)userAgent.charAt(msie + 5) : 53;
            if (version2 <= 54) {
                if (acceptEncodings) {
                    reqFields.remove(HttpHeader.ACCEPT_ENCODING);
                }
                if (request.isSecure()) {
                    int windows;
                    boolean badOs = false;
                    if (version2 == 54 && (windows = userAgent.indexOf("Windows", msie + 5)) > 0) {
                        int end = userAgent.indexOf(41, windows + 8);
                        boolean bl = badOs = end < 0 || __IE6_BadOS.get(userAgent, windows + 8, end - windows - 8) != null;
                    }
                    if (version2 <= 53 || badOs) {
                        reqFields.remove(HttpHeader.KEEP_ALIVE);
                        reqFields.ensureField(CONNECTION_CLOSE);
                        resFields.ensureField(CONNECTION_CLOSE);
                        response2.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                    }
                }
                baseRequest.setHttpFields(reqFields);
                return target;
            }
        }
        return null;
    }
}

