/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.incoming.BitrateCalculator;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSize;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0002\u0010\fJ5\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0014\b\u0002\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"H\u0002\u00f8\u0001\u0000J]\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0002\u0010(J \u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b*\u0010+J\u000e\u0010,\u001a\u00020\b2\u0006\u0010$\u001a\u00020%J\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0016J\u0015\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b6J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010$\u001a\u00020%R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006>"}, d2={"Lorg/jitsi/nlj/RtpLayerDesc;", "", "eid", "", "tid", "sid", "height", "frameRate", "", "dependencyLayers", "", "softDependencyLayers", "(IIIID[Lorg/jitsi/nlj/RtpLayerDesc;[Lorg/jitsi/nlj/RtpLayerDesc;)V", "bitrateTracker", "Lorg/jitsi/nlj/util/BitrateTracker;", "[Lorg/jitsi/nlj/RtpLayerDesc;", "getEid", "()I", "getFrameRate", "()D", "getHeight", "index", "getIndex", "layerId", "getLayerId", "getSid", "getTid", "useSoftDependencies", "", "getUseSoftDependencies", "()Z", "setUseSoftDependencies", "(Z)V", "calcBitrate", "", "Lorg/jitsi/nlj/util/Bandwidth;", "nowMs", "", "rates", "copy", "(IIIID[Lorg/jitsi/nlj/RtpLayerDesc;[Lorg/jitsi/nlj/RtpLayerDesc;)Lorg/jitsi/nlj/RtpLayerDesc;", "getBitrate", "getBitrate-WElJv5I", "(J)D", "getBitrateBps", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "hasZeroBitrate", "inheritFrom", "", "other", "inheritFrom$jitsi_media_transform", "inheritStatistics", "tracker", "inheritStatistics$jitsi_media_transform", "layerHasZeroBitrate", "toString", "", "updateBitrate", "packetSize", "Lorg/jitsi/nlj/util/DataSize;", "Companion", "jitsi-media-transform"})
public class RtpLayerDesc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int eid;
    private final int tid;
    private final int sid;
    private final int height;
    private final double frameRate;
    @NotNull
    private final RtpLayerDesc[] dependencyLayers;
    @NotNull
    private final RtpLayerDesc[] softDependencyLayers;
    private boolean useSoftDependencies;
    @NotNull
    private BitrateTracker bitrateTracker;
    private final int layerId;
    private final int index;
    public static final int SUSPENDED_INDEX = -1;
    public static final int SUSPENDED_ENCODING_ID = -1;
    public static final int NO_HEIGHT = -1;
    public static final double NO_FRAME_RATE = -1.0;

    @JvmOverloads
    public RtpLayerDesc(int eid, int tid, int sid, int height, double frameRate, @NotNull RtpLayerDesc[] dependencyLayers, @NotNull RtpLayerDesc[] softDependencyLayers) {
        Intrinsics.checkNotNullParameter(dependencyLayers, "dependencyLayers");
        Intrinsics.checkNotNullParameter(softDependencyLayers, "softDependencyLayers");
        this.eid = eid;
        this.tid = tid;
        this.sid = sid;
        this.height = height;
        this.frameRate = frameRate;
        this.dependencyLayers = dependencyLayers;
        this.softDependencyLayers = softDependencyLayers;
        if (!(this.tid < 8)) {
            boolean $i$a$-require-RtpLayerDesc$32 = false;
            String $i$a$-require-RtpLayerDesc$32 = "Invalid temporal ID " + this.tid;
            throw new IllegalArgumentException($i$a$-require-RtpLayerDesc$32.toString());
        }
        if (!(this.sid < 8)) {
            boolean bl = false;
            String string = "Invalid spatial ID " + this.sid;
            throw new IllegalArgumentException(string.toString());
        }
        this.useSoftDependencies = true;
        this.bitrateTracker = BitrateCalculator.Companion.createBitrateTracker();
        this.layerId = Companion.getIndex(0, this.sid, this.tid);
        this.index = Companion.getIndex(this.eid, this.sid, this.tid);
    }

    public /* synthetic */ RtpLayerDesc(int n, int n2, int n3, int n4, double d, RtpLayerDesc[] rtpLayerDescArray, RtpLayerDesc[] rtpLayerDescArray2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        boolean $i$f$emptyArray;
        if ((n5 & 0x20) != 0) {
            $i$f$emptyArray = false;
            rtpLayerDescArray = (RtpLayerDesc[])((Object[])new RtpLayerDesc[0]);
        }
        if ((n5 & 0x40) != 0) {
            $i$f$emptyArray = false;
            rtpLayerDescArray2 = (RtpLayerDesc[])((Object[])new RtpLayerDesc[0]);
        }
        this(n, n2, n3, n4, d, rtpLayerDescArray, rtpLayerDescArray2);
    }

    public final int getEid() {
        return this.eid;
    }

    public final int getTid() {
        return this.tid;
    }

    public final int getSid() {
        return this.sid;
    }

    public final int getHeight() {
        return this.height;
    }

    public final double getFrameRate() {
        return this.frameRate;
    }

    @NotNull
    public final RtpLayerDesc copy(int eid, int tid, int sid, int height, double frameRate, @NotNull RtpLayerDesc[] dependencyLayers, @NotNull RtpLayerDesc[] softDependencyLayers) {
        RtpLayerDesc rtpLayerDesc;
        Intrinsics.checkNotNullParameter(dependencyLayers, "dependencyLayers");
        Intrinsics.checkNotNullParameter(softDependencyLayers, "softDependencyLayers");
        RtpLayerDesc it = rtpLayerDesc = new RtpLayerDesc(eid, tid, sid, height, frameRate, dependencyLayers, softDependencyLayers);
        boolean bl = false;
        it.inheritFrom$jitsi_media_transform(this);
        return rtpLayerDesc;
    }

    public static /* synthetic */ RtpLayerDesc copy$default(RtpLayerDesc rtpLayerDesc, int n, int n2, int n3, int n4, double d, RtpLayerDesc[] rtpLayerDescArray, RtpLayerDesc[] rtpLayerDescArray2, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n5 & 1) != 0) {
            n = rtpLayerDesc.eid;
        }
        if ((n5 & 2) != 0) {
            n2 = rtpLayerDesc.tid;
        }
        if ((n5 & 4) != 0) {
            n3 = rtpLayerDesc.sid;
        }
        if ((n5 & 8) != 0) {
            n4 = rtpLayerDesc.height;
        }
        if ((n5 & 0x10) != 0) {
            d = rtpLayerDesc.frameRate;
        }
        if ((n5 & 0x20) != 0) {
            rtpLayerDescArray = rtpLayerDesc.dependencyLayers;
        }
        if ((n5 & 0x40) != 0) {
            rtpLayerDescArray2 = rtpLayerDesc.softDependencyLayers;
        }
        return rtpLayerDesc.copy(n, n2, n3, n4, d, rtpLayerDescArray, rtpLayerDescArray2);
    }

    public final boolean getUseSoftDependencies() {
        return this.useSoftDependencies;
    }

    public final void setUseSoftDependencies(boolean bl) {
        this.useSoftDependencies = bl;
    }

    public final int getLayerId() {
        return this.layerId;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public String toString() {
        return "subjective_quality=" + this.index + ",temporal_id=" + this.tid + ",spatial_id=" + this.sid;
    }

    public final void inheritStatistics$jitsi_media_transform(@NotNull BitrateTracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        this.bitrateTracker = tracker;
    }

    public final void inheritFrom$jitsi_media_transform(@NotNull RtpLayerDesc other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.inheritStatistics$jitsi_media_transform(other.bitrateTracker);
        this.useSoftDependencies = other.useSoftDependencies;
    }

    public final boolean updateBitrate(@NotNull DataSize packetSize, long nowMs) {
        Intrinsics.checkNotNullParameter(packetSize, "packetSize");
        boolean wasInactive = this.hasZeroBitrate(nowMs);
        this.bitrateTracker.update(packetSize, nowMs);
        return wasInactive && packetSize.getBits() > 0L;
    }

    public double getBitrate-WElJv5I(long nowMs) {
        return BandwidthKt.sum(RtpLayerDesc.calcBitrate$default(this, nowMs, null, 2, null).values());
    }

    public final double getBitrateBps(long nowMs) {
        return this.getBitrate-WElJv5I(nowMs);
    }

    private final Map<Integer, Bandwidth> calcBitrate(long nowMs, Map<Integer, Bandwidth> rates) {
        RtpLayerDesc it;
        RtpLayerDesc element$iv;
        int n;
        if (rates.containsKey(this.index)) {
            return rates;
        }
        rates.put(this.index, Bandwidth.box-impl(this.bitrateTracker.getRate-WElJv5I(nowMs)));
        RtpLayerDesc[] $this$forEach$iv = this.dependencyLayers;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.calcBitrate(nowMs, rates);
        }
        if (this.useSoftDependencies) {
            $this$forEach$iv = this.softDependencyLayers;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                it.calcBitrate(nowMs, rates);
            }
        }
        return rates;
    }

    static /* synthetic */ Map calcBitrate$default(RtpLayerDesc rtpLayerDesc, long l, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calcBitrate");
        }
        if ((n & 2) != 0) {
            map = new HashMap();
        }
        return rtpLayerDesc.calcBitrate(l, map);
    }

    private final boolean layerHasZeroBitrate(long nowMs) {
        return this.bitrateTracker.getAccumulatedSize(nowMs).getBits() == 0L;
    }

    public boolean hasZeroBitrate(long nowMs) {
        boolean bl;
        RtpLayerDesc it;
        RtpLayerDesc element$iv;
        int n;
        int n2;
        boolean $i$f$any;
        RtpLayerDesc[] $this$any$iv;
        block6: {
            if (!this.layerHasZeroBitrate(nowMs)) {
                return false;
            }
            $this$any$iv = this.dependencyLayers;
            $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$any$iv[n];
                boolean bl2 = false;
                if (!(!it.layerHasZeroBitrate(nowMs))) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        if (this.useSoftDependencies) {
            boolean bl3;
            block7: {
                $this$any$iv = this.softDependencyLayers;
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$any$iv[n];
                    boolean bl4 = false;
                    if (!(!it.layerHasZeroBitrate(nowMs))) continue;
                    bl3 = true;
                    break block7;
                }
                bl3 = false;
            }
            if (bl3) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d7 = nodeStatsBlock = new NodeStatsBlock(String.valueOf(this.layerId));
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d7.addNumber("frameRate", this.frameRate);
        $this$getNodeStats_u24lambda_u2d7.addNumber("height", this.height);
        $this$getNodeStats_u24lambda_u2d7.addNumber("index", this.index);
        $this$getNodeStats_u24lambda_u2d7.addNumber("bitrate_bps", this.getBitrate-WElJv5I(System.currentTimeMillis()));
        $this$getNodeStats_u24lambda_u2d7.addNumber("tid", this.tid);
        $this$getNodeStats_u24lambda_u2d7.addNumber("sid", this.sid);
        return nodeStatsBlock;
    }

    @JvmOverloads
    public RtpLayerDesc(int eid, int tid, int sid, int height, double frameRate, @NotNull RtpLayerDesc[] dependencyLayers) {
        Intrinsics.checkNotNullParameter(dependencyLayers, "dependencyLayers");
        this(eid, tid, sid, height, frameRate, dependencyLayers, null, 64, null);
    }

    @JvmOverloads
    public RtpLayerDesc(int eid, int tid, int sid, int height, double frameRate) {
        this(eid, tid, sid, height, frameRate, null, null, 96, null);
    }

    @JvmStatic
    public static final int getIndex(int eid, int sid, int tid) {
        return Companion.getIndex(eid, sid, tid);
    }

    @JvmStatic
    public static final int getEidFromIndex(int index) {
        return Companion.getEidFromIndex(index);
    }

    @JvmStatic
    public static final int getSidFromIndex(int index) {
        return Companion.getSidFromIndex(index);
    }

    @JvmStatic
    public static final int getTidFromIndex(int index) {
        return Companion.getTidFromIndex(index);
    }

    @JvmStatic
    @NotNull
    public static final String indexString(int index) {
        return Companion.indexString(index);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/nlj/RtpLayerDesc$Companion;", "", "()V", "NO_FRAME_RATE", "", "NO_HEIGHT", "", "SUSPENDED_ENCODING_ID", "SUSPENDED_INDEX", "getEidFromIndex", "index", "getIndex", "eid", "sid", "tid", "getSidFromIndex", "getTidFromIndex", "indexString", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int getIndex(int eid, int sid, int tid) {
            int e = eid < 0 ? 0 : eid;
            int s2 = sid < 0 ? 0 : sid;
            int t = tid < 0 ? 0 : tid;
            return e << 6 | s2 << 3 | t;
        }

        @JvmStatic
        public final int getEidFromIndex(int index) {
            return index >> 6;
        }

        @JvmStatic
        public final int getSidFromIndex(int index) {
            return (index & 0x38) >> 3;
        }

        @JvmStatic
        public final int getTidFromIndex(int index) {
            return index & 7;
        }

        @JvmStatic
        @NotNull
        public final String indexString(int index) {
            return index == -1 ? "SUSP" : "E" + this.getEidFromIndex(index) + "S" + this.getSidFromIndex(index) + "T" + this.getTidFromIndex(index);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

