/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.nlj.RtpReceiverImpl;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.QueueStatistics;
import org.jitsi.utils.stats.BucketStats;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.JvbLastNKt;
import org.jitsi.videobridge.VideobridgeConfig;
import org.jitsi.videobridge.VideobridgeExpireThread;
import org.jitsi.videobridge.colibri2.Colibri2UtilKt;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.load_management.JvbLoadManager;
import org.jitsi.videobridge.load_management.LastNReducer;
import org.jitsi.videobridge.load_management.PacketRateLoadSampler;
import org.jitsi.videobridge.load_management.PacketRateMeasurement;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayEndpointSender;
import org.jitsi.videobridge.shutdown.ShutdownManager;
import org.jitsi.videobridge.shutdown.ShutdownState;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.util.UlimitCheck;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsIqProvider;
import org.jitsi.xmpp.extensions.colibri.ForcefulShutdownIqProvider;
import org.jitsi.xmpp.extensions.colibri.GracefulShutdownIqProvider;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.IqProviderUtils;
import org.jitsi.xmpp.extensions.health.HealthCheckIQ;
import org.jitsi.xmpp.extensions.health.HealthCheckIQProvider;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.UdpCandidatePacketExtension;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class Videobridge {
    private static final Logger logger = new LoggerImpl(Videobridge.class.getName());
    public static final Random RANDOM = new Random();
    private final Map<String, Conference> conferencesById = new HashMap<String, Conference>();
    private final Map<String, Conference> conferencesByMeetingId = new HashMap<String, Conference>();
    private final JvbHealthChecker jvbHealthChecker = new JvbHealthChecker();
    @NotNull
    private final Clock clock;
    private final Statistics statistics = new Statistics();
    private final VideobridgeExpireThread videobridgeExpireThread;
    private final JvbLoadManager<PacketRateMeasurement> jvbLoadManager;
    private final ScheduledFuture<?> loadSamplerTask;
    @NotNull
    private final org.jitsi.utils.version.Version version;
    @Nullable
    private final String releaseId;
    @NotNull
    private final ShutdownManager shutdownManager;
    private boolean drainMode = VideobridgeConfig.Companion.getInitialDrainMode();

    public Videobridge(@Nullable XmppConnection xmppConnection, @NotNull ShutdownServiceImpl shutdownService, @NotNull org.jitsi.utils.version.Version version2, @Nullable String releaseId, @NotNull Clock clock) {
        this.clock = clock;
        this.videobridgeExpireThread = new VideobridgeExpireThread(this);
        this.jvbLoadManager = new JvbLoadManager<PacketRateMeasurement>(PacketRateMeasurement.getLoadedThreshold(), PacketRateMeasurement.getRecoveryThreshold(), new LastNReducer(this::getConferences, JvbLastNKt.jvbLastNSingleton));
        this.loadSamplerTask = TaskPools.SCHEDULED_POOL.scheduleAtFixedRate(new PacketRateLoadSampler(this, loadMeasurement -> {
            this.jvbLoadManager.loadUpdate((PacketRateMeasurement)loadMeasurement);
            this.getStatistics().stressLevel = this.jvbLoadManager.getCurrentStressLevel();
            return Unit.INSTANCE;
        }), 0L, 10L, TimeUnit.SECONDS);
        if (xmppConnection != null) {
            xmppConnection.setEventHandler(new XmppConnectionEventHandler());
        }
        this.version = version2;
        this.releaseId = releaseId;
        this.shutdownManager = new ShutdownManager(shutdownService, logger);
        this.jvbHealthChecker.start();
    }

    @NotNull
    public JvbHealthChecker getJvbHealthChecker() {
        return this.jvbHealthChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Conference doCreateConference(@Nullable EntityBareJid name, String meetingId, boolean isRtcStatsEnabled) {
        Conference conference = null;
        do {
            String id = this.generateConferenceID();
            Map<String, Conference> map = this.conferencesById;
            synchronized (map) {
                if (meetingId != null && this.conferencesByMeetingId.containsKey(meetingId)) {
                    throw new IllegalStateException("Already have a meeting with meetingId " + meetingId);
                }
                if (!this.conferencesById.containsKey(id)) {
                    conference = new Conference(this, id, name, meetingId, isRtcStatsEnabled);
                    this.conferencesById.put(id, conference);
                    this.statistics.currentConferences.inc();
                    if (meetingId != null) {
                        this.conferencesByMeetingId.put(meetingId, conference);
                    }
                }
            }
        } while (conference == null);
        return conference;
    }

    void localEndpointCreated(boolean visitor2) {
        this.statistics.currentLocalEndpoints.inc();
        if (visitor2) {
            this.statistics.currentVisitors.inc();
        }
    }

    void localEndpointExpired(boolean visitor2) {
        long remainingEndpoints = this.statistics.currentLocalEndpoints.decAndGet();
        if (visitor2) {
            this.statistics.currentVisitors.dec();
        }
        if (remainingEndpoints < 0L) {
            logger.warn("Invalid endpoint count " + remainingEndpoints + ". Disabling endpoint-count based shutdown!");
            return;
        }
        this.shutdownManager.maybeShutdown(remainingEndpoints);
    }

    @NotNull
    private Conference createConference(@Nullable EntityBareJid name, String meetingId, boolean isRtcStatsEnabled) {
        Conference conference = this.doCreateConference(name, meetingId, isRtcStatsEnabled);
        logger.info(() -> "create_conf, id=" + conference.getID() + " meetingId=" + meetingId);
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireConference(Conference conference) {
        String id = conference.getID();
        String meetingId = conference.getMeetingId();
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            if (conference.equals(this.conferencesById.get(id))) {
                this.conferencesById.remove(id);
                this.statistics.currentConferences.dec();
                if (meetingId != null && conference.equals(this.conferencesByMeetingId.get(meetingId))) {
                    this.conferencesByMeetingId.remove(meetingId);
                }
                conference.expire();
            }
        }
    }

    private String generateConferenceID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConference(String id) {
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            return this.conferencesById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConferenceByMeetingId(@NotNull String meetingId) {
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            return this.conferencesByMeetingId.get(meetingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Conference> getConferences() {
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            return new HashSet<Conference>(this.conferencesById.values());
        }
    }

    public IQ handleConferenceModifyIq(ConferenceModifyIQ conferenceModifyIQ) {
        Conference conference;
        try {
            conference = this.getOrCreateConference(conferenceModifyIQ);
        }
        catch (ConferenceNotFoundException e) {
            return Colibri2UtilKt.createConferenceNotFoundError(conferenceModifyIQ, conferenceModifyIQ.getMeetingId());
        }
        catch (ConferenceAlreadyExistsException e) {
            return Colibri2UtilKt.createConferenceAlreadyExistsError(conferenceModifyIQ, conferenceModifyIQ.getMeetingId());
        }
        catch (InGracefulShutdownException e) {
            return Colibri2UtilKt.createGracefulShutdownErrorResponse(conferenceModifyIQ);
        }
        catch (XmppStringprepException e) {
            return ErrorUtilKt.createError(conferenceModifyIQ, StanzaError.Condition.bad_request, "Invalid conference name (not a JID)");
        }
        return conference.handleConferenceModifyIQ(conferenceModifyIQ);
    }

    private void handleColibriRequest(XmppConnection.ColibriRequest request) {
        Conference conference;
        ConferenceModifyIQ iq = request.getRequest();
        String id = request.getRequest().getMeetingId();
        try {
            conference = this.getOrCreateConference(request.getRequest());
        }
        catch (ConferenceNotFoundException e) {
            request.getCallback().invoke(Colibri2UtilKt.createConferenceNotFoundError(iq, id));
            return;
        }
        catch (ConferenceAlreadyExistsException e) {
            request.getCallback().invoke(Colibri2UtilKt.createConferenceAlreadyExistsError(iq, id));
            return;
        }
        catch (InGracefulShutdownException e) {
            request.getCallback().invoke(Colibri2UtilKt.createGracefulShutdownErrorResponse(iq));
            return;
        }
        catch (XmppStringprepException e) {
            request.getCallback().invoke(ErrorUtilKt.createError(iq, StanzaError.Condition.bad_request, "Invalid conference name (not a JID)"));
            return;
        }
        conference.enqueueColibriRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Conference getOrCreateConference(ConferenceModifyIQ conferenceModifyIQ) throws InGracefulShutdownException, XmppStringprepException, ConferenceAlreadyExistsException, ConferenceNotFoundException {
        String meetingId = conferenceModifyIQ.getMeetingId();
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            Conference conference = this.getConferenceByMeetingId(meetingId);
            if (conferenceModifyIQ.getCreate()) {
                if (conference != null) {
                    logger.warn("Will not create conference, conference already exists for meetingId=" + meetingId);
                    throw new ConferenceAlreadyExistsException();
                }
                if (this.isInGracefulShutdown()) {
                    logger.warn("Will not create conference in shutdown mode.");
                    throw new InGracefulShutdownException();
                }
                String conferenceName = conferenceModifyIQ.getConferenceName();
                EntityBareJid entityBareJid = conferenceName == null ? null : JidCreate.entityBareFrom(conferenceName);
                return this.createConference(entityBareJid, meetingId, conferenceModifyIQ.isRtcstatsEnabled());
            }
            if (conference == null) {
                logger.warn("Conference with meetingId=" + meetingId + " not found.");
                throw new ConferenceNotFoundException();
            }
            return conference;
        }
    }

    public IQ handleHealthCheckIQ(HealthCheckIQ healthCheckIQ) {
        try {
            return IQ.createResultIQ(healthCheckIQ);
        }
        catch (Exception e) {
            logger.warn("Exception while handling health check IQ request", e);
            return ErrorUtilKt.createError(healthCheckIQ, StanzaError.Condition.internal_server_error, e.getMessage());
        }
    }

    public void shutdown(boolean graceful) {
        this.shutdownManager.initiateShutdown(graceful);
        this.shutdownManager.maybeShutdown(this.statistics.currentLocalEndpoints.get());
    }

    public void setDrainMode(boolean enable) {
        logger.info("Received drain request. enable=" + enable);
        this.drainMode = enable;
    }

    public boolean getDrainMode() {
        return this.drainMode;
    }

    public boolean isInGracefulShutdown() {
        return this.shutdownManager.getState() == ShutdownState.GRACEFUL_SHUTDOWN;
    }

    public ShutdownState getShutdownState() {
        return this.shutdownManager.getState();
    }

    public void start() {
        UlimitCheck.printUlimits();
        this.videobridgeExpireThread.start();
        ForcefulShutdownIqProvider.registerIQProvider();
        GracefulShutdownIqProvider.registerIQProvider();
        new ColibriStatsIqProvider();
        ProviderManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceUdpTransportPacketExtension>(IceUdpTransportPacketExtension.class));
        DefaultPacketExtensionProvider<UdpCandidatePacketExtension> udpCandidatePacketExtensionProvider = new DefaultPacketExtensionProvider<UdpCandidatePacketExtension>(UdpCandidatePacketExtension.class);
        ProviderManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", udpCandidatePacketExtensionProvider);
        DefaultPacketExtensionProvider<IceCandidatePacketExtension> iceCandidatePacketExtensionProvider = new DefaultPacketExtensionProvider<IceCandidatePacketExtension>(IceCandidatePacketExtension.class);
        ProviderManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", iceCandidatePacketExtensionProvider);
        ProviderManager.addExtensionProvider("rtcp-mux", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceRtcpmuxPacketExtension>(IceRtcpmuxPacketExtension.class));
        ProviderManager.addExtensionProvider("fingerprint", "urn:xmpp:jingle:apps:dtls:0", new DefaultPacketExtensionProvider<DtlsFingerprintPacketExtension>(DtlsFingerprintPacketExtension.class));
        HealthCheckIQProvider.registerIQProvider();
        IqProviderUtils.registerProviders();
    }

    public void stop() {
        this.videobridgeExpireThread.stop();
        if (this.loadSamplerTask != null) {
            this.loadSamplerTask.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedJsonObject getDebugState(String conferenceId, String endpointId, boolean full) {
        OrderedJsonObject debugState = new OrderedJsonObject();
        debugState.put("shutdownState", this.shutdownManager.getState().toString());
        debugState.put("drain", (Object)this.drainMode);
        debugState.put("time", (Object)System.currentTimeMillis());
        debugState.put("load-management", this.jvbLoadManager.getStats());
        debugState.put("overall_bridge_jitter", (Object)PacketTransitStats.getBridgeJitter());
        JSONObject conferences = new JSONObject();
        debugState.put("conferences", conferences);
        if (StringUtils.isBlank(conferenceId)) {
            this.getConferences().forEach(conference -> conferences.put(conference.getID(), conference.getDebugState(full, null)));
        } else {
            Conference conference2;
            JSONObject jSONObject = conferences;
            synchronized (jSONObject) {
                conference2 = this.conferencesById.get(conferenceId);
            }
            conferences.put(conferenceId, conference2 == null ? "null" : conference2.getDebugState(full, endpointId));
        }
        return debugState;
    }

    public JSONObject getQueueStats() {
        JSONObject queueStats = new JSONObject();
        queueStats.put("srtp_send_queue", this.getJsonFromQueueStatisticsAndErrorHandler(Endpoint.queueErrorCounter, "Endpoint-outgoing-packet-queue"));
        queueStats.put("relay_srtp_send_queue", this.getJsonFromQueueStatisticsAndErrorHandler(Relay.queueErrorCounter, "Relay-outgoing-packet-queue"));
        queueStats.put("relay_endpoint_sender_srtp_send_queue", this.getJsonFromQueueStatisticsAndErrorHandler(RelayEndpointSender.queueErrorCounter, "RelayEndpointSender-outgoing-packet-queue"));
        queueStats.put("rtp_receiver_queue", this.getJsonFromQueueStatisticsAndErrorHandler(RtpReceiverImpl.Companion.getQueueErrorCounter(), "rtp-receiver-incoming-packet-queue"));
        queueStats.put("rtp_sender_queue", this.getJsonFromQueueStatisticsAndErrorHandler(RtpSenderImpl.Companion.getQueueErrorCounter(), "rtp-sender-incoming-packet-queue"));
        queueStats.put("colibri_queue", QueueStatistics.Companion.getStatistics().get("colibri-queue"));
        queueStats.put("bridge-channel-message-incoming-queue", this.getJsonFromQueueStatisticsAndErrorHandler(null, "bridge-channel-message-incoming-queue"));
        return queueStats;
    }

    private OrderedJsonObject getJsonFromQueueStatisticsAndErrorHandler(CountingErrorHandler countingErrorHandler, String queueName) {
        OrderedJsonObject json = (OrderedJsonObject)QueueStatistics.Companion.getStatistics().get(queueName);
        if (countingErrorHandler != null) {
            if (json == null) {
                json = new OrderedJsonObject();
                json.put("dropped_packets", (Object)countingErrorHandler.getNumPacketsDropped());
            }
            json.put("exceptions", (Object)countingErrorHandler.getNumExceptions());
        }
        return json;
    }

    @NotNull
    public org.jitsi.utils.version.Version getVersion() {
        return this.version;
    }

    @Nullable
    public String getReleaseId() {
        return this.releaseId;
    }

    static {
        BufferPool.Companion.setGetArray(ByteBufferPool::getBuffer);
        BufferPool.Companion.setReturnArray(buffer -> {
            ByteBufferPool.returnBuffer(buffer);
            return Unit.INSTANCE;
        });
        org.jitsi.nlj.util.BufferPool.Companion.setGetBuffer(ByteBufferPool::getBuffer);
        org.jitsi.nlj.util.BufferPool.Companion.setReturnBuffer(buffer -> {
            ByteBufferPool.returnBuffer(buffer);
            return Unit.INSTANCE;
        });
    }

    private static class InGracefulShutdownException
    extends Exception {
        private InGracefulShutdownException() {
        }
    }

    private static class ConferenceAlreadyExistsException
    extends Exception {
        private ConferenceAlreadyExistsException() {
        }
    }

    private static class ConferenceNotFoundException
    extends Exception {
        private ConferenceNotFoundException() {
        }
    }

    public static class Statistics {
        public CounterMetric incomingBitrateExpirations = VideobridgeMetricsContainer.getInstance().registerCounter("incoming_bitrate_expirations", "Number of times our AIMDs have expired the incoming bitrate.");
        public CounterMetric failedConferences = VideobridgeMetricsContainer.getInstance().registerCounter("failed_conferences", "Number of conferences in which ALL of the endpoints failed ICE.");
        public CounterMetric partiallyFailedConferences = VideobridgeMetricsContainer.getInstance().registerCounter("partially_failed_conferences", "Number of conferences in which SOME of the endpoints failed ICE.");
        public CounterMetric conferencesCompleted = VideobridgeMetricsContainer.getInstance().registerCounter("conferences_completed", "The total number of conferences completed/expired on the Videobridge.");
        public CounterMetric conferencesCreated = VideobridgeMetricsContainer.getInstance().registerCounter("conferences_created", "The total number of conferences created on the Videobridge.");
        public AtomicLong totalConferenceSeconds = new AtomicLong();
        public AtomicLong totalLossControlledParticipantMs = new AtomicLong();
        public AtomicLong totalLossLimitedParticipantMs = new AtomicLong();
        public AtomicLong totalLossDegradedParticipantMs = new AtomicLong();
        public CounterMetric dataChannelMessagesReceived = VideobridgeMetricsContainer.getInstance().registerCounter("data_channel_messages_received", "Number of messages received from the data channels of the endpoints of this conference.");
        public CounterMetric dataChannelMessagesSent = VideobridgeMetricsContainer.getInstance().registerCounter("data_channel_messages_sent", "Number of messages sent via the data channels of the endpoints of this conference.");
        public CounterMetric colibriWebSocketMessagesReceived = VideobridgeMetricsContainer.getInstance().registerCounter("colibri_web_socket_messages_received", "Number of messages received from the data channels of the endpoints of this conference.");
        public CounterMetric colibriWebSocketMessagesSent = VideobridgeMetricsContainer.getInstance().registerCounter("colibri_web_socket_messages_sent", "Number of messages sent via the data channels of the endpoints of this conference.");
        public AtomicLong totalBytesReceived = new AtomicLong();
        public AtomicLong totalBytesSent = new AtomicLong();
        public CounterMetric packetsReceived = VideobridgeMetricsContainer.getInstance().registerCounter("packets_received", "Number of RTP packets received in conferences on this videobridge.");
        public CounterMetric packetsSent = VideobridgeMetricsContainer.getInstance().registerCounter("packets_sent", "Number of RTP packets sent in conferences on this videobridge.");
        public AtomicLong totalRelayBytesReceived = new AtomicLong();
        public AtomicLong totalRelayBytesSent = new AtomicLong();
        public CounterMetric relayPacketsReceived = VideobridgeMetricsContainer.getInstance().registerCounter("relay_packets_received", "Number of RTP packets received by relays in conferences on this videobridge.");
        public CounterMetric relayPacketsSent = VideobridgeMetricsContainer.getInstance().registerCounter("relay_packets_sent", "Number of RTP packets sent by relays in conferences on this videobridge.");
        public CounterMetric totalEndpoints = VideobridgeMetricsContainer.getInstance().registerCounter("endpoints", "The total number of endpoints created.");
        public CounterMetric totalVisitors = VideobridgeMetricsContainer.getInstance().registerCounter("visitors", "The total number of visitor endpoints created.");
        public CounterMetric numEndpointsNoMessageTransportAfterDelay = VideobridgeMetricsContainer.getInstance().registerCounter("endpoints_no_message_transport_after_delay", "Number of endpoints which had not established a relay message transport even after some delay.");
        public CounterMetric totalRelays = VideobridgeMetricsContainer.getInstance().registerCounter("relays", "The total number of relays created.");
        public CounterMetric numRelaysNoMessageTransportAfterDelay = VideobridgeMetricsContainer.getInstance().registerCounter("relays_no_message_transport_after_delay", "Number of relays which had not established a relay message transport even after some delay.");
        public CounterMetric dominantSpeakerChanges = VideobridgeMetricsContainer.getInstance().registerCounter("dominant_speaker_changes", "Number of times the dominant speaker in any conference changed.");
        public CounterMetric endpointsDtlsFailed = VideobridgeMetricsContainer.getInstance().registerCounter("endpoints_dtls_failed", "Number of endpoints whose ICE connection was established, but DTLS wasn't (at time of expiration).");
        public Double stressLevel = 0.0;
        public BucketStats tossedPacketsEnergy = new BucketStats(Stream.iterate(0L, n -> n + 1L).limit(17L).map(w -> Math.max(8L * w - 1L, 0L)).collect(Collectors.toList()), "", "");
        public CounterMetric preemptiveKeyframeRequestsSent = VideobridgeMetricsContainer.getInstance().registerCounter("preemptive_keyframe_requests_sent", "Number of preemptive keyframe requests that were sent.");
        public CounterMetric preemptiveKeyframeRequestsSuppressed = VideobridgeMetricsContainer.getInstance().registerCounter("preemptive_keyframe_requests_suppressed", "Number of preemptive keyframe requests that were not sent because no endpoints were in stage view.");
        public CounterMetric keyframesReceived = VideobridgeMetricsContainer.getInstance().registerCounter("keyframes_received", "Number of keyframes that were received (updated on endpoint expiration).");
        public CounterMetric layeringChangesReceived = VideobridgeMetricsContainer.getInstance().registerCounter("layering_changes_received", "Number of times the layering of an incoming video stream changed (updated on endpoint expiration).");
        public AtomicLong totalVideoStreamMillisecondsReceived = new AtomicLong();
        public LongGaugeMetric currentLocalEndpoints = VideobridgeMetricsContainer.getInstance().registerLongGauge("local_endpoints", "Number of local endpoints that exist currently.");
        public LongGaugeMetric currentVisitors = VideobridgeMetricsContainer.getInstance().registerLongGauge("current_visitors", "Number of visitor endpoints.");
        public LongGaugeMetric currentConferences = VideobridgeMetricsContainer.getInstance().registerLongGauge("conferences", "Current number of conferences.");
    }

    private class XmppConnectionEventHandler
    implements XmppConnection.EventHandler {
        private XmppConnectionEventHandler() {
        }

        @Override
        public void colibriRequestReceived(@NotNull XmppConnection.ColibriRequest request) {
            Videobridge.this.handleColibriRequest(request);
        }

        @Override
        @NotNull
        public IQ versionIqReceived(@NotNull Version iq) {
            Version versionResult = new Version(Videobridge.this.version.getApplicationName(), Videobridge.this.version.toString(), System.getProperty("os.name"));
            versionResult.setType(IQ.Type.result);
            return versionResult;
        }

        @Override
        @NotNull
        public IQ healthCheckIqReceived(@NotNull HealthCheckIQ iq) {
            return Videobridge.this.handleHealthCheckIQ(iq);
        }
    }
}

