/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class DefaultPacketExtensionProvider<C extends AbstractPacketExtension>
extends ExtensionElementProvider<C> {
    private static final Logger logger = Logger.getLogger(DefaultPacketExtensionProvider.class.getName());
    private final Class<C> packetClass;

    public DefaultPacketExtensionProvider(Class<C> c) {
        this.packetClass = c;
    }

    @Override
    public C parse(XmlPullParser parser2, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        AbstractPacketExtension packetExtension;
        try {
            packetExtension = (AbstractPacketExtension)this.packetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Could not create an instance of class " + this.packetClass.getName(), e);
            throw new SmackParsingException(e.getMessage());
        }
        int attrCount = parser2.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            packetExtension.setAttribute(parser2.getAttributeName(i), parser2.getAttributeValue(i));
        }
        boolean done = false;
        String elementName = null;
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT || eventType == XmlPullParser.Event.END_ELEMENT) {
                elementName = parser2.getName();
            }
            String namespace = parser2.getNamespace();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Will parse event " + eventType + " for " + elementName + " ns=" + namespace + " class=" + packetExtension.getClass().getSimpleName());
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                ExtensionElementProvider<ExtensionElement> provider = ProviderManager.getExtensionProvider(elementName, namespace);
                if (provider == null) {
                    logger.fine("Could not add a provider for element " + elementName + " from namespace " + namespace);
                } else {
                    ExtensionElement childExtension = (ExtensionElement)provider.parse(parser2);
                    if (namespace != null && childExtension instanceof AbstractPacketExtension) {
                        ((AbstractPacketExtension)childExtension).setNamespace(namespace);
                    }
                    packetExtension.addChildExtension(childExtension);
                }
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser2.getName().equals(packetExtension.getElementName())) {
                done = true;
            }
            if (eventType == XmlPullParser.Event.TEXT_CHARACTERS) {
                String text = parser2.getText();
                packetExtension.setText(text);
            }
            if (!logger.isLoggable(Level.FINEST) || elementName == null) continue;
            logger.finest("Done parsing " + elementName);
        }
        return (C)packetExtension;
    }
}

