/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;

public class AdHocCommandDataProvider
extends IQProvider<AdHocCommandData> {
    @Override
    public AdHocCommandData parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        AdHocCommandData adHocCommandData = new AdHocCommandData();
        DataFormProvider dataFormProvider = new DataFormProvider();
        adHocCommandData.setSessionID(parser2.getAttributeValue("", "sessionid"));
        adHocCommandData.setNode(parser2.getAttributeValue("", "node"));
        String status = parser2.getAttributeValue("", "status");
        if (AdHocCommand.Status.executing.toString().equalsIgnoreCase(status)) {
            adHocCommandData.setStatus(AdHocCommand.Status.executing);
        } else if (AdHocCommand.Status.completed.toString().equalsIgnoreCase(status)) {
            adHocCommandData.setStatus(AdHocCommand.Status.completed);
        } else if (AdHocCommand.Status.canceled.toString().equalsIgnoreCase(status)) {
            adHocCommandData.setStatus(AdHocCommand.Status.canceled);
        }
        String action = parser2.getAttributeValue("", "action");
        if (action != null) {
            AdHocCommand.Action realAction = AdHocCommand.Action.valueOf(action);
            if (realAction == null || realAction.equals((Object)AdHocCommand.Action.unknown)) {
                adHocCommandData.setAction(AdHocCommand.Action.unknown);
            } else {
                adHocCommandData.setAction(realAction);
            }
        }
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            String namespace = parser2.getNamespace();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                String elementName = parser2.getName();
                if (parser2.getName().equals("actions")) {
                    String execute = parser2.getAttributeValue("", "execute");
                    if (execute == null) continue;
                    adHocCommandData.setExecuteAction(AdHocCommand.Action.valueOf(execute));
                    continue;
                }
                if (parser2.getName().equals("next")) {
                    adHocCommandData.addAction(AdHocCommand.Action.next);
                    continue;
                }
                if (parser2.getName().equals("complete")) {
                    adHocCommandData.addAction(AdHocCommand.Action.complete);
                    continue;
                }
                if (parser2.getName().equals("prev")) {
                    adHocCommandData.addAction(AdHocCommand.Action.prev);
                    continue;
                }
                if (elementName.equals("x") && namespace.equals("jabber:x:data")) {
                    adHocCommandData.setForm((DataForm)dataFormProvider.parse(parser2));
                    continue;
                }
                if (parser2.getName().equals("note")) {
                    String typeString = parser2.getAttributeValue("", "type");
                    AdHocCommandNote.Type type2 = typeString != null ? AdHocCommandNote.Type.valueOf(typeString) : AdHocCommandNote.Type.info;
                    String value2 = parser2.nextText();
                    adHocCommandData.addNote(new AdHocCommandNote(type2, value2));
                    continue;
                }
                if (!parser2.getName().equals("error")) continue;
                StanzaError error = PacketParserUtils.parseError(parser2);
                adHocCommandData.setError(error);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("command")) continue;
            done = true;
        }
        return adHocCommandData;
    }

    public static class SessionExpiredError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        @Override
        public AdHocCommandData.SpecificError parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.sessionExpired);
        }
    }

    public static class BadSessionIDError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        @Override
        public AdHocCommandData.SpecificError parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badSessionid);
        }
    }

    public static class BadPayloadError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        @Override
        public AdHocCommandData.SpecificError parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badPayload);
        }
    }

    public static class BadLocaleError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        @Override
        public AdHocCommandData.SpecificError parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badLocale);
        }
    }

    public static class MalformedActionError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        @Override
        public AdHocCommandData.SpecificError parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.malformedAction);
        }
    }

    public static class BadActionError
    extends ExtensionElementProvider<AdHocCommandData.SpecificError> {
        @Override
        public AdHocCommandData.SpecificError parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badAction);
        }
    }
}

