/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import java.net.InetAddress;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.PcapAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPcapAddress
implements PcapAddress {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPcapAddress.class);
    private final InetAddress address;
    private final InetAddress netmask;
    private final InetAddress broadcastAddr;
    private final InetAddress dstAddr;

    protected AbstractPcapAddress(NativeMappings.pcap_addr pcapAddr, short saFamily, String devName) {
        if (pcapAddr == null) {
            throw new NullPointerException();
        }
        if (pcapAddr.addr != null && pcapAddr.addr.getSaFamily() != 0) {
            if (pcapAddr.addr.getSaFamily() != saFamily) {
                this.warn(pcapAddr.addr.getSaFamily(), saFamily, devName, "addr");
                this.address = null;
            } else {
                this.address = this.ntoInetAddress(pcapAddr.addr);
            }
        } else {
            this.address = null;
        }
        if (pcapAddr.netmask != null && pcapAddr.netmask.getSaFamily() != 0) {
            if (pcapAddr.netmask.getSaFamily() != saFamily) {
                this.warn(pcapAddr.netmask.getSaFamily(), saFamily, devName, "netmask");
                this.netmask = null;
            } else {
                this.netmask = this.ntoInetAddress(pcapAddr.netmask);
            }
        } else {
            this.netmask = null;
        }
        if (pcapAddr.broadaddr != null && pcapAddr.broadaddr.getSaFamily() != 0) {
            if (pcapAddr.broadaddr.getSaFamily() != saFamily) {
                this.warn(pcapAddr.broadaddr.getSaFamily(), saFamily, devName, "broadaddr");
                this.broadcastAddr = null;
            } else {
                this.broadcastAddr = this.ntoInetAddress(pcapAddr.broadaddr);
            }
        } else {
            this.broadcastAddr = null;
        }
        if (pcapAddr.dstaddr != null && pcapAddr.dstaddr.getSaFamily() != 0) {
            if (pcapAddr.dstaddr.getSaFamily() != saFamily) {
                this.warn(pcapAddr.dstaddr.getSaFamily(), saFamily, devName, "dstaddr");
                this.dstAddr = null;
            } else {
                this.dstAddr = this.ntoInetAddress(pcapAddr.dstaddr);
            }
        } else {
            this.dstAddr = null;
        }
    }

    private void warn(short actualSaFamily, short expectedSaFamily, String devName, String field) {
        if (logger.isWarnEnabled()) {
            logger.warn("Couldn't analyze an address. devName: {}, field: {}, actual saFamily: {}, expected saFamily: {}", devName, field, actualSaFamily, expectedSaFamily);
        }
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public InetAddress getNetmask() {
        return this.netmask;
    }

    @Override
    public InetAddress getBroadcastAddress() {
        return this.broadcastAddr;
    }

    @Override
    public InetAddress getDestinationAddress() {
        return this.dstAddr;
    }

    protected abstract InetAddress ntoInetAddress(NativeMappings.sockaddr var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(190);
        sb.append("address: [").append(this.address).append("] netmask: [").append(this.netmask).append("] broadcastAddr: [").append(this.broadcastAddr).append("] dstAddr [").append(this.dstAddr).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPcapAddress other = (AbstractPcapAddress)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.broadcastAddr == null ? other.broadcastAddr != null : !this.broadcastAddr.equals(other.broadcastAddr)) {
            return false;
        }
        if (this.dstAddr == null ? other.dstAddr != null : !this.dstAddr.equals(other.dstAddr)) {
            return false;
        }
        return !(this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask));
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.address == null ? 0 : this.address.hashCode());
        result2 = 31 * result2 + (this.broadcastAddr == null ? 0 : this.broadcastAddr.hashCode());
        result2 = 31 * result2 + (this.dstAddr == null ? 0 : this.dstAddr.hashCode());
        result2 = 31 * result2 + (this.netmask == null ? 0 : this.netmask.hashCode());
        return result2;
    }
}

