/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerAsymmetricSignatureSignerContext;
import org.keycloak.crypto.ServerAsymmetricSignatureVerifierContext;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.models.KeycloakSession;

public class AsymmetricSignatureProvider
implements SignatureProvider {
    private final KeycloakSession session;
    private final String algorithm;

    public AsymmetricSignatureProvider(KeycloakSession session, String algorithm) {
        this.session = session;
        this.algorithm = algorithm;
    }

    public SignatureSignerContext signer() throws SignatureException {
        return new ServerAsymmetricSignatureSignerContext(this.session, this.algorithm);
    }

    public SignatureSignerContext signer(KeyWrapper key) throws SignatureException {
        SignatureProvider.checkKeyForSignature((KeyWrapper)key, (String)this.algorithm, (String)"RSA");
        return new ServerAsymmetricSignatureSignerContext(key);
    }

    public SignatureVerifierContext verifier(String kid) throws VerificationException {
        return new ServerAsymmetricSignatureVerifierContext(this.session, kid, this.algorithm);
    }

    public SignatureVerifierContext verifier(KeyWrapper key) throws VerificationException {
        SignatureProvider.checkKeyForVerification((KeyWrapper)key, (String)this.algorithm, (String)"RSA");
        return new ServerAsymmetricSignatureVerifierContext(key);
    }

    public boolean isAsymmetricAlgorithm() {
        return true;
    }
}

