/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentArrayHolder;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.SemanticException;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ArrayInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = ArrayInitializer.class.getSimpleName();
    private final DomainResultAssembler<Integer> listIndexAssembler;
    private final DomainResultAssembler<?> elementAssembler;
    private final int indexBase;

    public ArrayInitializer(NavigablePath navigablePath, PluralAttributeMapping arrayDescriptor, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler<?> collectionKeyAssembler, DomainResultAssembler<?> collectionValueKeyAssembler, DomainResultAssembler<Integer> listIndexAssembler, DomainResultAssembler<?> elementAssembler) {
        super(navigablePath, arrayDescriptor, parentAccess, lockMode, collectionKeyAssembler, collectionValueKeyAssembler);
        this.listIndexAssembler = listIndexAssembler;
        this.elementAssembler = elementAssembler;
        this.indexBase = this.getCollectionAttributeMapping().getIndexMetadata().getListIndexBase();
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    public PersistentArrayHolder<?> getCollectionInstance() {
        return (PersistentArrayHolder)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Integer indexValue = this.listIndexAssembler.assemble(rowProcessingState);
        if (indexValue == null) {
            throw new SemanticException("Illegal null index value encountered while reading: " + this.getCollectionAttributeMapping().getNavigableRole());
        }
        int index = indexValue;
        if (this.indexBase != 0) {
            index -= this.indexBase;
        }
        for (int i = loadingState.size(); i <= index; ++i) {
            loadingState.add(i, null);
        }
        loadingState.set(index, this.elementAssembler.assemble(rowProcessingState));
    }

    public String toString() {
        return "ArrayInitializer{" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

