/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.config.MultiOption;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;

public class OptionBuilder<T> {
    private static final Supplier<List<String>> EMPTY_VALUES_SUPPLIER = List::of;
    private static final Supplier<List<String>> BOOLEAN_TYPE_VALUES = new Supplier<List<String>>(){
        List<String> values = List.of(Boolean.TRUE.toString(), Boolean.FALSE.toString());

        @Override
        public List<String> get() {
            return this.values;
        }
    };
    private final Class<T> type;
    private final Class<T> auxiliaryType;
    private final String key;
    private OptionCategory category;
    private boolean hidden;
    private boolean build;
    private String description;
    private Optional<T> defaultValue;
    private Supplier<List<String>> expectedValues;

    public OptionBuilder(String key, Class<T> type) {
        this(key, type, null);
    }

    public OptionBuilder(String key, Class<T> type, Class<T> auxiliaryType) {
        this.type = type;
        this.auxiliaryType = auxiliaryType;
        this.key = key;
        this.category = OptionCategory.GENERAL;
        this.hidden = false;
        this.build = false;
        this.description = null;
        this.defaultValue = Boolean.class.equals(type) ? Optional.of(Boolean.FALSE) : Optional.empty();
        this.expectedValues = EMPTY_VALUES_SUPPLIER;
        if (Boolean.class.equals(type)) {
            this.expectedValues(BOOLEAN_TYPE_VALUES);
        }
        if (Enum.class.isAssignableFrom(type)) {
            this.expectedValues(type);
        }
        if (auxiliaryType != null && Enum.class.isAssignableFrom(auxiliaryType)) {
            this.expectedValues(auxiliaryType);
        }
    }

    public OptionBuilder<T> category(OptionCategory category) {
        this.category = category;
        return this;
    }

    public OptionBuilder<T> hidden() {
        this.hidden = true;
        return this;
    }

    public OptionBuilder<T> buildTime(boolean build) {
        this.build = build;
        return this;
    }

    public OptionBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public OptionBuilder<T> defaultValue(Optional<T> defaultV) {
        this.defaultValue = defaultV;
        return this;
    }

    public OptionBuilder<T> defaultValue(T defaultV) {
        this.defaultValue = Optional.ofNullable(defaultV);
        return this;
    }

    public OptionBuilder<T> expectedValues(Supplier<List<String>> expected) {
        this.expectedValues = expected;
        return this;
    }

    public OptionBuilder<T> expectedValues(final Class<? extends Enum> expected) {
        this.expectedValues = new Supplier<List<String>>(){
            List<String> values;
            {
                this.values = List.of((Enum[])expected.getEnumConstants()).stream().map(Object::toString).collect(Collectors.toList());
            }

            @Override
            public List<String> get() {
                return this.values;
            }
        };
        return this;
    }

    public OptionBuilder<T> expectedValues(final T ... expected) {
        this.expectedValues = new Supplier<List<String>>(){
            List<String> values;
            {
                this.values = List.of(expected).stream().map(v -> v.toString()).collect(Collectors.toList());
            }

            @Override
            public List<String> get() {
                return this.values;
            }
        };
        return this;
    }

    public Option<T> build() {
        if (this.auxiliaryType != null) {
            return new MultiOption(this.type, this.auxiliaryType, this.key, this.category, this.hidden, this.build, this.description, this.defaultValue, this.expectedValues);
        }
        return new Option<T>(this.type, this.key, this.category, this.hidden, this.build, this.description, this.defaultValue, this.expectedValues);
    }
}

