/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.marshall.MarshallUtil;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;

public abstract class SessionClusterEvent
implements ClusterEvent {
    private String realmId;
    private String eventKey;
    private boolean resendingEvent;
    private String siteId;
    private String nodeId;
    private static final int VERSION_1 = 1;

    public static <T extends SessionClusterEvent> T createEvent(Class<T> eventClass, String eventKey, KeycloakSession session, String realmId, boolean resendingEvent) {
        try {
            SessionClusterEvent event = (SessionClusterEvent)eventClass.newInstance();
            event.setData(session, eventKey, realmId, resendingEvent);
            return (T)event;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setData(KeycloakSession session, String eventKey, String realmId, boolean resendingEvent) {
        this.realmId = realmId;
        this.eventKey = eventKey;
        this.resendingEvent = resendingEvent;
        TopologyInfo topology = InfinispanUtil.getTopologyInfo(session);
        this.siteId = topology.getMySiteName();
        this.nodeId = topology.getMyNodeName();
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public boolean isResendingEvent() {
        return this.resendingEvent;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionClusterEvent that = (SessionClusterEvent)o;
        return Objects.equals(this.realmId, that.realmId) && Objects.equals(this.eventKey, that.eventKey);
    }

    public int hashCode() {
        return Objects.hash(this.realmId, this.eventKey);
    }

    public String toString() {
        String simpleClassName = this.getClass().getSimpleName();
        return String.format("%s [ realmId=%s ]", simpleClassName, this.realmId);
    }

    protected void marshallTo(ObjectOutput output) throws IOException {
        output.writeByte(1);
        MarshallUtil.marshallString((String)this.realmId, (ObjectOutput)output);
        MarshallUtil.marshallString((String)this.eventKey, (ObjectOutput)output);
        output.writeBoolean(this.resendingEvent);
        MarshallUtil.marshallString((String)this.siteId, (ObjectOutput)output);
        MarshallUtil.marshallString((String)this.nodeId, (ObjectOutput)output);
    }

    protected void unmarshallFrom(ObjectInput input) throws IOException {
        switch (input.readByte()) {
            case 1: {
                this.unmarshallFromVersion1(input);
                break;
            }
            default: {
                throw new IOException("Unknown version");
            }
        }
    }

    private void unmarshallFromVersion1(ObjectInput input) throws IOException {
        this.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
        this.eventKey = MarshallUtil.unmarshallString((ObjectInput)input);
        this.resendingEvent = input.readBoolean();
        this.siteId = MarshallUtil.unmarshallString((ObjectInput)input);
        this.nodeId = MarshallUtil.unmarshallString((ObjectInput)input);
    }
}

