/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.util;

import java.security.cert.X509Certificate;

public enum XmlKeyInfoKeyNameTransformer {
    NONE{

        @Override
        public String getKeyName(String keyId, X509Certificate certificate) {
            return null;
        }
    }
    ,
    KEY_ID{

        @Override
        public String getKeyName(String keyId, X509Certificate certificate) {
            return keyId;
        }
    }
    ,
    CERT_SUBJECT{

        @Override
        public String getKeyName(String keyId, X509Certificate certificate) {
            return certificate == null ? null : (certificate.getSubjectDN() == null ? null : certificate.getSubjectDN().getName());
        }
    };


    public abstract String getKeyName(String var1, X509Certificate var2);

    public static XmlKeyInfoKeyNameTransformer from(String name, XmlKeyInfoKeyNameTransformer defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        try {
            return XmlKeyInfoKeyNameTransformer.valueOf(name);
        }
        catch (IllegalArgumentException ex) {
            return defaultValue;
        }
    }
}

