/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.FilteredClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class CuratedApplication
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 7816596453653911149L;
    private static final String AUGMENTOR = "io.quarkus.runner.bootstrap.AugmentActionImpl";
    private final Map<ArtifactKey, ClassPathElement> augmentationElements = new HashMap<ArtifactKey, ClassPathElement>();
    private volatile QuarkusClassLoader augmentClassLoader;
    private volatile QuarkusClassLoader baseRuntimeClassLoader;
    private final QuarkusBootstrap quarkusBootstrap;
    private final CurationResult curationResult;
    private final ConfiguredClassLoading configuredClassLoading;
    final ApplicationModel appModel;
    final AtomicInteger runtimeClassLoaderCount = new AtomicInteger();

    CuratedApplication(QuarkusBootstrap quarkusBootstrap, CurationResult curationResult, ConfiguredClassLoading configuredClassLoading) {
        this.quarkusBootstrap = quarkusBootstrap;
        this.curationResult = curationResult;
        this.appModel = curationResult.getApplicationModel();
        this.configuredClassLoading = configuredClassLoading;
    }

    public boolean isFlatClassPath() {
        return this.configuredClassLoading.isFlatTestClassPath();
    }

    public ApplicationModel getApplicationModel() {
        return this.appModel;
    }

    public QuarkusBootstrap getQuarkusBootstrap() {
        return this.quarkusBootstrap;
    }

    public Object runInAugmentClassLoader(String consumerName, Map<String, Object> params) {
        return this.runInCl(consumerName, params, this.getAugmentClassLoader());
    }

    public CurationResult getCurationResult() {
        return this.curationResult;
    }

    public AugmentAction createAugmentor() {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class).newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AugmentAction createAugmentor(String functionName, Map<String, Object> props) {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            Function function = (Function)this.getAugmentClassLoader().loadClass(functionName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            List res = (List)function.apply(props);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class, List.class).newInstance(this, res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object runInCl(String consumerName, Map<String, Object> params, QuarkusClassLoader cl) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass(consumerName);
            BiConsumer biConsumer = (BiConsumer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            biConsumer.accept(this, params);
            BiConsumer biConsumer2 = biConsumer;
            return biConsumer2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private synchronized void processCpElement(ResolvedDependency artifact, Consumer<ClassPathElement> consumer) {
        ClassPathElement cpe;
        if (!artifact.isJar()) {
            consumer.accept(ClassPathElement.EMPTY);
            return;
        }
        final Collection<String> filteredResources = this.configuredClassLoading.getRemovedResources().get(artifact.getKey());
        if (filteredResources != null) {
            final Consumer<ClassPathElement> old = consumer;
            consumer = new Consumer<ClassPathElement>(){

                @Override
                public void accept(ClassPathElement classPathElement) {
                    old.accept(new FilteredClassPathElement(classPathElement, filteredResources));
                }
            };
        }
        if ((cpe = this.augmentationElements.get(artifact.getKey())) != null) {
            consumer.accept(cpe);
            return;
        }
        PathTree contentTree = artifact.getContentTree();
        if (contentTree.isEmpty()) {
            consumer.accept(ClassPathElement.EMPTY);
            return;
        }
        cpe = ClassPathElement.fromDependency(artifact);
        consumer.accept(cpe);
        this.augmentationElements.put(artifact.getKey(), cpe);
    }

    private void addCpElement(QuarkusClassLoader.Builder builder, ResolvedDependency dep, ClassPathElement element) {
        ArtifactKey key = dep.getKey();
        if (this.configuredClassLoading.isParentFirstArtifact(key)) {
            builder.addParentFirstElement(element);
        } else if (dep.isFlagSet(1024)) {
            builder.addLesserPriorityElement(element);
        }
        builder.addElement(element);
    }

    public synchronized QuarkusClassLoader getAugmentClassLoader() {
        if (this.augmentClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Augmentation Class Loader: " + this.quarkusBootstrap.getMode(), this.quarkusBootstrap.getBaseClassLoader(), !this.quarkusBootstrap.isIsolateDeployment()).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled());
            builder.addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners());
            for (ResolvedDependency resolvedDependency : this.appModel.getDependencies()) {
                if (this.configuredClassLoading.isRemovedArtifact(resolvedDependency.getKey())) {
                    this.processCpElement(resolvedDependency, builder::addBannedElement);
                    continue;
                }
                if (this.configuredClassLoading.isReloadableArtifact(resolvedDependency.getKey())) continue;
                this.processCpElement(resolvedDependency, element -> this.addCpElement(builder, resolvedDependency, (ClassPathElement)element));
            }
            for (Path path : this.quarkusBootstrap.getAdditionalDeploymentArchives()) {
                builder.addElement(ClassPathElement.fromPath(path, false));
            }
            HashMap<String, byte[]> banned = new HashMap<String, byte[]>();
            for (Collection<String> i : this.configuredClassLoading.getRemovedResources().values()) {
                for (String j : i) {
                    banned.put(j, new byte[0]);
                }
            }
            builder.addBannedElement(new MemoryClassPathElement(banned, false));
            this.augmentClassLoader = builder.build();
        }
        return this.augmentClassLoader;
    }

    public synchronized QuarkusClassLoader getBaseRuntimeClassLoader() {
        if (this.baseRuntimeClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Base Runtime ClassLoader: " + this.quarkusBootstrap.getMode(), this.quarkusBootstrap.getBaseClassLoader(), false).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled());
            builder.addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners());
            if (this.configuredClassLoading.isFlatTestClassPath()) {
                for (Iterator<Path> root : this.quarkusBootstrap.getApplicationRoot()) {
                    builder.addElement(ClassPathElement.fromPath((Path)((Object)root), true));
                }
            } else {
                for (Iterator<Path> root : this.quarkusBootstrap.getApplicationRoot()) {
                    builder.addBannedElement(new ClassFilteredBannedElement(ClassPathElement.fromPath((Path)((Object)root), true)));
                }
            }
            HashSet<Path> hotReloadPaths = new HashSet<Path>();
            for (AdditionalDependency additionalDependency : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
                if (!additionalDependency.isHotReloadable()) {
                    for (Path root : additionalDependency.getResolvedPaths()) {
                        builder.addElement(ClassPathElement.fromPath(root, true));
                    }
                    continue;
                }
                for (Path root : additionalDependency.getResolvedPaths()) {
                    hotReloadPaths.add(root);
                    builder.addBannedElement(new ClassFilteredBannedElement(ClassPathElement.fromPath(root, true)));
                }
            }
            for (Path path : this.configuredClassLoading.getAdditionalClasspathElements()) {
                hotReloadPaths.add(path);
                builder.addBannedElement(new ClassFilteredBannedElement(ClassPathElement.fromPath(path, true)));
            }
            builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap(), true));
            HashMap<String, byte[]> banned = new HashMap<String, byte[]>();
            for (Collection<String> i : this.configuredClassLoading.getRemovedResources().values()) {
                for (String j : i) {
                    banned.put(j, new byte[0]);
                }
            }
            builder.addBannedElement(new MemoryClassPathElement(banned, true));
            for (ResolvedDependency dependency : this.appModel.getDependencies()) {
                if (this.configuredClassLoading.isRemovedArtifact(dependency.getKey())) {
                    this.processCpElement(dependency, builder::addBannedElement);
                    continue;
                }
                if (!dependency.isRuntimeCp() || CuratedApplication.isHotReloadable(dependency, hotReloadPaths) || this.configuredClassLoading.isReloadableArtifact(dependency.getKey()) || !this.configuredClassLoading.isFlatTestClassPath() && dependency.isReloadable() && this.appModel.getReloadableWorkspaceDependencies().contains(dependency.getKey())) continue;
                this.processCpElement(dependency, element -> this.addCpElement(builder, dependency, (ClassPathElement)element));
            }
            this.baseRuntimeClassLoader = builder.build();
        }
        return this.baseRuntimeClassLoader;
    }

    private static boolean isHotReloadable(ResolvedDependency a, Set<Path> hotReloadPaths) {
        for (Path p : a.getContentTree().getRoots()) {
            if (!hotReloadPaths.contains(p)) continue;
            return true;
        }
        return false;
    }

    public QuarkusClassLoader createDeploymentClassLoader() {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Deployment Class Loader: " + this.quarkusBootstrap.getMode(), this.getAugmentClassLoader(), false).addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners()).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled()).setAggregateParentResources(true);
        for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
            builder.addElement(ClassPathElement.fromPath(root, true));
        }
        builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap(), false));
        for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
            for (Path root : i.getResolvedPaths()) {
                builder.addElement(ClassPathElement.fromPath(root, true));
            }
        }
        for (ResolvedDependency dependency : this.appModel.getDependencies()) {
            if (this.configuredClassLoading.isRemovedArtifact(dependency.getKey()) || !dependency.isRuntimeCp() || !dependency.isJar() || (!dependency.isReloadable() || !this.appModel.getReloadableWorkspaceDependencies().contains(dependency.getKey())) && !this.configuredClassLoading.isReloadableArtifact(dependency.getKey())) continue;
            this.processCpElement(dependency, element -> this.addCpElement(builder, dependency, (ClassPathElement)element));
        }
        for (Path root : this.configuredClassLoading.getAdditionalClasspathElements()) {
            builder.addElement(ClassPathElement.fromPath(root, true));
        }
        return builder.build();
    }

    public QuarkusClassLoader createRuntimeClassLoader(Map<String, byte[]> resources, Map<String, byte[]> transformedClasses) {
        return this.createRuntimeClassLoader(this.getBaseRuntimeClassLoader(), resources, transformedClasses);
    }

    public QuarkusClassLoader createRuntimeClassLoader(ClassLoader base, Map<String, byte[]> resources, Map<String, byte[]> transformedClasses) {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Runtime ClassLoader: " + this.quarkusBootstrap.getMode() + " restart no:" + this.runtimeClassLoaderCount.getAndIncrement(), this.getBaseRuntimeClassLoader(), false).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled()).setAggregateParentResources(true);
        builder.setTransformedClasses(transformedClasses);
        builder.addElement(new MemoryClassPathElement(resources, true));
        for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
            builder.addElement(ClassPathElement.fromPath(root, true));
        }
        for (AdditionalDependency i : this.getQuarkusBootstrap().getAdditionalApplicationArchives()) {
            if (!i.isHotReloadable()) continue;
            for (Path root : i.getResolvedPaths()) {
                builder.addElement(ClassPathElement.fromPath(root, true));
            }
        }
        for (ResolvedDependency dependency : this.appModel.getDependencies()) {
            if (this.configuredClassLoading.isRemovedArtifact(dependency.getKey()) || !dependency.isRuntimeCp() || !dependency.isJar() || (!dependency.isReloadable() || !this.appModel.getReloadableWorkspaceDependencies().contains(dependency.getKey())) && !this.configuredClassLoading.isReloadableArtifact(dependency.getKey())) continue;
            this.processCpElement(dependency, element -> this.addCpElement(builder, dependency, (ClassPathElement)element));
        }
        for (Path root : this.configuredClassLoading.getAdditionalClasspathElements()) {
            builder.addElement(ClassPathElement.fromPath(root, true));
        }
        return builder.build();
    }

    public boolean isReloadableArtifact(ArtifactKey key) {
        return this.configuredClassLoading.isReloadableArtifact(key);
    }

    public boolean hasReloadableArtifacts() {
        return this.configuredClassLoading.hasReloadableArtifacts();
    }

    @Override
    public void close() {
        if (this.augmentClassLoader != null) {
            this.augmentClassLoader.close();
        }
        if (this.baseRuntimeClassLoader != null) {
            this.baseRuntimeClassLoader.close();
        }
        this.augmentationElements.clear();
    }

    static class ClassFilteredBannedElement
    implements ClassPathElement {
        private final ClassPathElement delegate;

        ClassFilteredBannedElement(ClassPathElement delegate) {
            this.delegate = delegate;
        }

        @Override
        public ArtifactKey getDependencyKey() {
            return this.delegate.getDependencyKey();
        }

        @Override
        public boolean isRuntime() {
            return this.delegate.isRuntime();
        }

        @Override
        public <T> T apply(Function<OpenPathTree, T> func) {
            return this.delegate.apply(func);
        }

        @Override
        public Path getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public ClassPathResource getResource(String name) {
            if (!name.endsWith(".class")) {
                return null;
            }
            return this.delegate.getResource(name);
        }

        @Override
        public Set<String> getProvidedResources() {
            return this.delegate.getProvidedResources().stream().filter(s -> s.endsWith(".class")).collect(Collectors.toSet());
        }

        @Override
        public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
            return this.delegate.getProtectionDomain(classLoader);
        }

        @Override
        public Manifest getManifest() {
            return this.delegate.getManifest();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

