/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import com.ibm.asyncutil.iteration.AsyncTrampoline;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.spi.AsyncOutputStream;

public final class ProviderHelper {
    private ProviderHelper() {
    }

    public static String readString(InputStream in) throws IOException {
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 1024)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public static String readString(InputStream in, MediaType mediaType) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream builder = new ByteArrayOutputStream();
        int wasRead = 0;
        do {
            if ((wasRead = in.read(buffer, 0, 1024)) <= 0) continue;
            builder.write(buffer, 0, wasRead);
        } while (wasRead > -1);
        byte[] bytes = builder.toByteArray();
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static List<MediaType> getAvailableMediaTypes(String[] mediaTypes) {
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String mediaType : mediaTypes) {
            types.add(MediaType.valueOf((String)mediaType));
        }
        return types;
    }

    public static List<Variant> getAvailableVariants(String[] mediaTypes) {
        return ProviderHelper.getAvailableVariants(ProviderHelper.getAvailableMediaTypes(mediaTypes));
    }

    public static List<Variant> getAvailableVariants(List<MediaType> mediaTypes) {
        Variant.VariantListBuilder builder = Variant.VariantListBuilder.newInstance();
        MediaType[] types = mediaTypes.toArray(new MediaType[mediaTypes.size()]);
        builder.mediaTypes(types);
        return builder.build();
    }

    public static void writeTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[2048];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    public static CompletionStage<Void> writeToAndCloseInput(InputStream in, AsyncOutputStream out) {
        return ProviderHelper.writeTo(in, out).whenComplete((v, t) -> {
            try {
                in.close();
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        });
    }

    public static CompletionStage<Void> writeTo(InputStream in, AsyncOutputStream out) {
        byte[] buf = new byte[2048];
        return AsyncTrampoline.asyncWhile(read -> read != -1, read -> out.asyncWrite(buf, 0, read.intValue()).thenApply(v -> ProviderHelper.asyncRead(in, buf)), (Object)ProviderHelper.asyncRead(in, buf)).thenApply(v -> null);
    }

    public static int asyncRead(InputStream in, byte[] buf) {
        try {
            return in.read(buf);
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    public static int asyncRead(InputStream in, byte[] buf, int offset, int length) {
        try {
            return in.read(buf, offset, length);
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    public static CompletionStage<Void> completedException(Throwable t) {
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        ret.completeExceptionally(t);
        return ret;
    }
}

