/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.proxy;

import io.quarkus.gizmo.ClassOutput;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProxyConfiguration<T> {
    private Class<?> anchorClass;
    private String proxyNameSuffix;
    private ClassLoader classLoader;
    private Class<T> superClass;
    private List<Class<?>> additionalInterfaces = new ArrayList(0);
    private ClassOutput classOutput;
    private boolean allowPackagePrivate = false;

    public List<Class<?>> getAdditionalInterfaces() {
        return Collections.unmodifiableList(this.additionalInterfaces);
    }

    public ProxyConfiguration<T> addAdditionalInterface(Class<?> iface) {
        if (!Modifier.isInterface(iface.getModifiers())) {
            throw new IllegalArgumentException("Class " + iface.getName() + " is not an interface");
        }
        this.additionalInterfaces.add(iface);
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProxyConfiguration<T> setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Class<?> getAnchorClass() {
        return this.anchorClass;
    }

    public ProxyConfiguration<T> setAnchorClass(Class<?> anchorClass) {
        this.anchorClass = anchorClass;
        return this;
    }

    public String getProxyNameSuffix() {
        return this.proxyNameSuffix;
    }

    public ProxyConfiguration<T> setProxyNameSuffix(String proxyNameSuffix) {
        this.proxyNameSuffix = proxyNameSuffix;
        return this;
    }

    public String getProxyName() {
        return this.getAnchorClass().getName() + this.proxyNameSuffix;
    }

    public Class<T> getSuperClass() {
        return this.superClass;
    }

    public ProxyConfiguration<T> setSuperClass(Class<T> superClass) {
        this.superClass = superClass;
        return this;
    }

    public ClassOutput getClassOutput() {
        return this.classOutput;
    }

    public ProxyConfiguration<T> setClassOutput(ClassOutput classOutput) {
        this.classOutput = classOutput;
        return this;
    }

    public boolean isAllowPackagePrivate() {
        return this.allowPackagePrivate;
    }

    public ProxyConfiguration<T> setAllowPackagePrivate(boolean allowPackagePrivate) {
        this.allowPackagePrivate = allowPackagePrivate;
        return this;
    }
}

